/*
 * Decompiled with CFR 0.152.
 */
package net.didion.jwnl.data;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.BitSet;
import net.didion.jwnl.JWNL;
import net.didion.jwnl.JWNLException;
import net.didion.jwnl.data.DictionaryElement;
import net.didion.jwnl.data.DictionaryElementType;
import net.didion.jwnl.data.LexFileIdMap;
import net.didion.jwnl.data.POS;
import net.didion.jwnl.data.Pointer;
import net.didion.jwnl.data.PointerTarget;
import net.didion.jwnl.data.PointerType;
import net.didion.jwnl.data.VerbFrame;
import net.didion.jwnl.data.Word;

public class Synset
extends PointerTarget
implements DictionaryElement {
    static final long serialVersionUID = 4038955719653496529L;
    protected POS _pos;
    protected Pointer[] _pointers;
    protected long _offset;
    protected Word[] _words;
    protected String _gloss;
    protected BitSet _verbFrameFlags;
    protected boolean _isAdjectiveCluster;
    protected long lexFileNum;
    protected String lexFileName;
    private transient String _cachedToString = null;

    public Synset(POS pos, long offset, Word[] words, Pointer[] pointers, String gloss, BitSet verbFrames) {
        this(pos, offset, words, pointers, gloss, verbFrames, false);
    }

    public Synset(POS pos, long offset, Word[] words, Pointer[] pointers, String gloss, BitSet verbFrames, boolean isAdjectiveCluster) {
        this._pos = pos;
        this._pointers = pointers;
        this._offset = offset;
        this._words = words;
        this._gloss = gloss;
        this._verbFrameFlags = verbFrames;
        this._isAdjectiveCluster = isAdjectiveCluster;
    }

    @Override
    public DictionaryElementType getType() {
        return DictionaryElementType.SYNSET;
    }

    @Override
    public boolean equals(Object object) {
        return object instanceof Synset && ((Synset)object).getPOS().equals(this.getPOS()) && ((Synset)object).getOffset() == this.getOffset();
    }

    public int hashCode() {
        return this.getPOS().hashCode() ^ (int)this.getOffset();
    }

    @Override
    public String toString() {
        if (this._cachedToString == null) {
            StringBuffer words = new StringBuffer();
            for (int i = 0; i < this.getWordsSize(); ++i) {
                if (i > 0) {
                    words.append(", ");
                }
                words.append(this.getWord(i).getLemma());
            }
            if (this.getGloss() != null) {
                words.append(" -- (" + this.getGloss() + ")");
            }
            this._cachedToString = JWNL.resolveMessage("DATA_TOSTRING_009", new Object[]{new Long(this.getOffset()), this.getPOS(), words.toString()});
        }
        return this._cachedToString;
    }

    @Override
    public POS getPOS() {
        return this._pos;
    }

    @Override
    public Pointer[] getPointers() {
        return this._pointers;
    }

    public String getGloss() {
        return this._gloss;
    }

    public Word[] getWords() {
        return this._words;
    }

    public int getWordsSize() {
        return this.getWords().length;
    }

    public Word getWord(int index) {
        return this._words[index];
    }

    public long getOffset() {
        return this._offset;
    }

    @Override
    public Object getKey() {
        return new Long(this.getOffset());
    }

    public boolean isAdjectiveCluster() {
        return this._isAdjectiveCluster;
    }

    public String[] getVerbFrames() {
        return VerbFrame.getFrames(this._verbFrameFlags);
    }

    public BitSet getVerbFrameFlags() {
        return this._verbFrameFlags;
    }

    public int[] getVerbFrameIndicies() {
        return VerbFrame.getVerbFrameIndicies(this._verbFrameFlags);
    }

    public boolean containsWord(String lemma) {
        for (int i = 0; i < this.getWordsSize(); ++i) {
            if (!this.getWord(i).getLemma().equals(lemma)) continue;
            return true;
        }
        return false;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this._pos = POS.getPOSForKey(this._pos.getKey());
    }

    public long getLexFileNum() {
        return this.lexFileNum;
    }

    public void setLexFileNum(long lexFileId) {
        this.lexFileNum = lexFileId;
        this.lexFileName = LexFileIdMap.getFileName(lexFileId);
    }

    public String getLexFileName() {
        return this.lexFileName;
    }

    public String getSenseKey(String lemma) {
        int ss_type = 5;
        if (this.getPOS().equals(POS.NOUN)) {
            ss_type = 1;
        } else if (this.getPOS().equals(POS.VERB)) {
            ss_type = 2;
        } else if (this.getPOS().equals(POS.ADJECTIVE)) {
            ss_type = 3;
        } else if (this.getPOS().equals(POS.ADVERB)) {
            ss_type = 4;
        }
        if (this.isAdjectiveCluster()) {
            ss_type = 5;
        }
        int lexId = -1;
        for (int i = 0; i < this.getWords().length; ++i) {
            Word w = this.getWords()[i];
            if (!w.getLemma().equals(lemma)) continue;
            lexId = w.getLexId();
        }
        String lexNumStr = "";
        long lexNum = this.getLexFileNum();
        lexNumStr = lexNum < 10L ? "0" + lexNum : String.valueOf(lexNum);
        String lexIdStr = "";
        lexIdStr = lexId < 10 ? "0" + lexId : String.valueOf(lexId);
        String senseKey = lemma + "%" + ss_type + ":" + lexNumStr;
        senseKey = senseKey + ":" + lexIdStr + ":";
        String head2 = ":";
        if (ss_type == 5) {
            try {
                Pointer headWord;
                Word[] words;
                Pointer[] p = this.getPointers(PointerType.SIMILAR_TO);
                if (p.length > 0 && (words = (headWord = p[0]).getTargetSynset().getWords()).length > 0) {
                    head2 = words[0].getLemma() + ":";
                    lexIdStr = "";
                    lexIdStr = words[0].getLexId() < 10 ? "0" + words[0].getLexId() : String.valueOf(words[0].getLexId());
                    head2 = head2 + lexIdStr;
                }
            }
            catch (JWNLException e) {
                e.printStackTrace();
            }
        }
        senseKey = senseKey + head2;
        return senseKey;
    }
}

