/*
 * Decompiled with CFR 0.152.
 */
package net.didion.jwnl.data;

import java.util.Collection;
import java.util.Iterator;
import net.didion.jwnl.JWNLException;
import net.didion.jwnl.data.POS;
import net.didion.jwnl.data.PointerTarget;
import net.didion.jwnl.data.PointerType;
import net.didion.jwnl.data.Synset;
import net.didion.jwnl.data.list.PointerTargetNode;
import net.didion.jwnl.data.list.PointerTargetNodeList;
import net.didion.jwnl.data.list.PointerTargetTree;
import net.didion.jwnl.data.list.PointerTargetTreeNode;
import net.didion.jwnl.data.list.PointerTargetTreeNodeList;

public final class PointerUtils {
    public static final int INFINITY = Integer.MAX_VALUE;
    private static final PointerUtils INSTANCE = new PointerUtils();

    public static PointerUtils getInstance() {
        return INSTANCE;
    }

    private PointerUtils() {
    }

    public PointerTargetNodeList getDirectHypernyms(Synset synset) throws JWNLException {
        return this.getPointerTargets(synset, PointerType.HYPERNYM);
    }

    public PointerTargetTree getHypernymTree(Synset synset) throws JWNLException {
        return this.getHypernymTree(synset, Integer.MAX_VALUE);
    }

    public PointerTargetTree getHypernymTree(Synset synset, int depth) throws JWNLException {
        return new PointerTargetTree(synset, this.makePointerTargetTreeList(synset, PointerType.HYPERNYM, depth));
    }

    public PointerTargetNodeList getDirectHyponyms(Synset synset) throws JWNLException {
        return this.getPointerTargets(synset, PointerType.HYPONYM);
    }

    public PointerTargetTree getHyponymTree(Synset synset) throws JWNLException {
        return this.getHyponymTree(synset, Integer.MAX_VALUE);
    }

    public PointerTargetTree getHyponymTree(Synset synset, int depth) throws JWNLException {
        return new PointerTargetTree(synset, this.makePointerTargetTreeList(synset, PointerType.HYPONYM, depth));
    }

    public PointerTargetNodeList getCoordinateTerms(Synset synset) throws JWNLException {
        PointerTargetNodeList list2 = new PointerTargetNodeList();
        Iterator itr = this.getDirectHypernyms(synset).iterator();
        while (itr.hasNext()) {
            list2.addAll((Collection)this.getPointerTargets(((PointerTargetNode)itr.next()).getSynset(), PointerType.HYPONYM));
        }
        return list2;
    }

    public PointerTargetNodeList getAntonyms(Synset synset) throws JWNLException {
        return this.getPointerTargets(synset, PointerType.ANTONYM);
    }

    public PointerTargetTree getExtendedAntonyms(Synset synset) throws JWNLException {
        return this.getExtendedAntonyms(synset, 1);
    }

    public PointerTargetTree getExtendedAntonyms(Synset synset, int depth) throws JWNLException {
        PointerTargetTreeNodeList list2 = new PointerTargetTreeNodeList();
        if (synset.getPOS() == POS.ADJECTIVE) {
            PointerTargetNodeList antonyms = this.getAntonyms(synset);
            list2 = this.makePointerTargetTreeList(antonyms, PointerType.SIMILAR_TO, PointerType.ANTONYM, depth, false);
        }
        return new PointerTargetTree(new PointerTargetTreeNode((PointerTarget)synset, list2, null));
    }

    public PointerTargetTree getIndirectAntonyms(Synset synset) throws JWNLException {
        return this.getIndirectAntonyms(synset, 1);
    }

    public PointerTargetTree getIndirectAntonyms(Synset synset, int depth) throws JWNLException {
        PointerTargetTreeNodeList list2 = new PointerTargetTreeNodeList();
        if (synset.getPOS() == POS.ADJECTIVE) {
            PointerTargetNodeList synonyms = this.getSynonyms(synset);
            list2 = this.makePointerTargetTreeList(synonyms, PointerType.ANTONYM, PointerType.ANTONYM, depth, false);
        }
        return new PointerTargetTree(new PointerTargetTreeNode((PointerTarget)synset, list2, null));
    }

    public PointerTargetNodeList getAttributes(Synset synset) throws JWNLException {
        return this.getPointerTargets(synset, PointerType.ATTRIBUTE);
    }

    public PointerTargetNodeList getAlsoSees(Synset synset) throws JWNLException {
        return this.getPointerTargets(synset, PointerType.SEE_ALSO);
    }

    public PointerTargetTree getAlsoSeeTree(Synset synset, int depth) throws JWNLException {
        return new PointerTargetTree(synset, this.makePointerTargetTreeList(synset, PointerType.SEE_ALSO, depth));
    }

    public PointerTargetNodeList getMeronyms(Synset synset) throws JWNLException {
        PointerTargetNodeList list2 = new PointerTargetNodeList();
        list2.addAll((Collection)this.getPartMeronyms(synset));
        list2.addAll((Collection)this.getMemberMeronyms(synset));
        list2.addAll((Collection)this.getSubstanceMeronyms(synset));
        return list2;
    }

    public PointerTargetNodeList getPartMeronyms(Synset synset) throws JWNLException {
        return this.getPointerTargets(synset, PointerType.PART_MERONYM);
    }

    public PointerTargetNodeList getMemberMeronyms(Synset synset) throws JWNLException {
        return this.getPointerTargets(synset, PointerType.MEMBER_MERONYM);
    }

    public PointerTargetNodeList getSubstanceMeronyms(Synset synset) throws JWNLException {
        return this.getPointerTargets(synset, PointerType.SUBSTANCE_MERONYM);
    }

    public PointerTargetTree getInteritedMeronyms(Synset synset) throws JWNLException {
        return this.getInheritedMeronyms(synset, Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    public PointerTargetTree getInheritedMeronyms(Synset synset, int pointerDepth, int ancestorDepth) throws JWNLException {
        PointerType[] types = new PointerType[]{PointerType.PART_MERONYM, PointerType.MEMBER_MERONYM, PointerType.SUBSTANCE_MERONYM};
        return this.makeInheritedTree(synset, types, null, pointerDepth, ancestorDepth, false);
    }

    public PointerTargetTree getInheritedPartMeronyms(Synset synset) throws JWNLException {
        return this.getInheritedPartMeronyms(synset, Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    public PointerTargetTree getInheritedPartMeronyms(Synset synset, int pointerDepth, int ancestorDepth) throws JWNLException {
        return this.makeInheritedTree(synset, PointerType.PART_MERONYM, null, pointerDepth, ancestorDepth);
    }

    public PointerTargetTree getInheritedMemberMeronyms(Synset synset) throws JWNLException {
        return this.getInheritedMemberMeronyms(synset, Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    public PointerTargetTree getInheritedMemberMeronyms(Synset synset, int pointerDepth, int ancestorDepth) throws JWNLException {
        return this.makeInheritedTree(synset, PointerType.MEMBER_MERONYM, null, pointerDepth, ancestorDepth);
    }

    public PointerTargetTree getInheritedSubstanceMeronyms(Synset synset) throws JWNLException {
        return this.getInheritedSubstanceMeronyms(synset, Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    public PointerTargetTree getInheritedSubstanceMeronyms(Synset synset, int pointerDepth, int ancestorDepth) throws JWNLException {
        return this.makeInheritedTree(synset, PointerType.SUBSTANCE_MERONYM, null, pointerDepth, ancestorDepth);
    }

    public PointerTargetNodeList getHolonyms(Synset synset) throws JWNLException {
        PointerTargetNodeList list2 = new PointerTargetNodeList();
        list2.addAll((Collection)this.getPartHolonyms(synset));
        list2.addAll((Collection)this.getMemberHolonyms(synset));
        list2.addAll((Collection)this.getSubstanceHolonyms(synset));
        return list2;
    }

    public PointerTargetNodeList getPartHolonyms(Synset synset) throws JWNLException {
        return this.getPointerTargets(synset, PointerType.PART_HOLONYM);
    }

    public PointerTargetNodeList getMemberHolonyms(Synset synset) throws JWNLException {
        return this.getPointerTargets(synset, PointerType.MEMBER_HOLONYM);
    }

    public PointerTargetNodeList getSubstanceHolonyms(Synset synset) throws JWNLException {
        return this.getPointerTargets(synset, PointerType.SUBSTANCE_HOLONYM);
    }

    public PointerTargetTree getInheritedHolonyms(Synset synset) throws JWNLException {
        return this.getInheritedHolonyms(synset, Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    public PointerTargetTree getInheritedHolonyms(Synset synset, int pointerDepth, int ancestorDepth) throws JWNLException {
        PointerType[] types = new PointerType[]{PointerType.PART_HOLONYM, PointerType.MEMBER_HOLONYM, PointerType.SUBSTANCE_HOLONYM};
        return this.makeInheritedTree(synset, types, null, pointerDepth, ancestorDepth, false);
    }

    public PointerTargetTree getInheritedPartHolonyms(Synset synset) throws JWNLException {
        return this.getInheritedPartHolonyms(synset, Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    public PointerTargetTree getInheritedPartHolonyms(Synset synset, int pointerDepth, int ancestorDepth) throws JWNLException {
        return this.makeInheritedTree(synset, PointerType.PART_HOLONYM, null, pointerDepth, ancestorDepth);
    }

    public PointerTargetTree getInheritedMemberHolonyms(Synset synset) throws JWNLException {
        return this.getInheritedMemberHolonyms(synset, Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    public PointerTargetTree getInheritedMemberHolonyms(Synset synset, int pointerDepth, int ancestorDepth) throws JWNLException {
        return this.makeInheritedTree(synset, PointerType.MEMBER_HOLONYM, null, pointerDepth, ancestorDepth);
    }

    public PointerTargetTree getInheritedSubstanceHolonyms(Synset synset) throws JWNLException {
        return this.getInheritedSubstanceHolonyms(synset, Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    public PointerTargetTree getInheritedSubstanceHolonyms(Synset synset, int pointerDepth, int ancestorDepth) throws JWNLException {
        return this.makeInheritedTree(synset, PointerType.SUBSTANCE_HOLONYM, null, pointerDepth, ancestorDepth);
    }

    public PointerTargetNodeList getEntailments(Synset synset) throws JWNLException {
        return this.getPointerTargets(synset, PointerType.ENTAILMENT);
    }

    public PointerTargetTree getEntailmentTree(Synset synset) throws JWNLException {
        return this.getEntailmentTree(synset, Integer.MAX_VALUE);
    }

    public PointerTargetTree getEntailmentTree(Synset synset, int depth) throws JWNLException {
        return new PointerTargetTree(synset, this.makePointerTargetTreeList(synset, PointerType.ENTAILMENT, depth));
    }

    public PointerTargetNodeList getEntailedBy(Synset synset) throws JWNLException {
        return this.getPointerTargets(synset, PointerType.ENTAILED_BY);
    }

    public PointerTargetTree getEntailedByTree(Synset synset) throws JWNLException {
        return this.getEntailedByTree(synset, Integer.MAX_VALUE);
    }

    public PointerTargetTree getEntailedByTree(Synset synset, int depth) throws JWNLException {
        return new PointerTargetTree(synset, this.makePointerTargetTreeList(synset, PointerType.ENTAILED_BY, depth));
    }

    public PointerTargetNodeList getCauses(Synset synset) throws JWNLException {
        return this.getPointerTargets(synset, PointerType.CAUSE);
    }

    public PointerTargetTree getCauseTree(Synset synset) throws JWNLException {
        return this.getCauseTree(synset, Integer.MAX_VALUE);
    }

    public PointerTargetTree getCauseTree(Synset synset, int depth) throws JWNLException {
        return new PointerTargetTree(synset, this.makePointerTargetTreeList(synset, PointerType.CAUSE, depth));
    }

    public PointerTargetNodeList getVerbGroup(Synset synset) throws JWNLException {
        PointerTargetNodeList nodes = new PointerTargetNodeList();
        nodes.add(new PointerTargetNode(synset, PointerType.VERB_GROUP));
        int maxIndex = 0;
        int index = -1;
        do {
            PointerTargetNode node = (PointerTargetNode)nodes.get(++index);
            for (PointerTargetNode testNode : this.getPointerTargets(node.getSynset(), PointerType.VERB_GROUP)) {
                if (nodes.contains(testNode)) continue;
                nodes.add(testNode);
                ++maxIndex;
            }
        } while (index < maxIndex);
        return nodes;
    }

    public PointerTargetNodeList getParticipleOf(Synset synset) throws JWNLException {
        return this.getPointerTargets(synset, PointerType.PARTICIPLE_OF);
    }

    public PointerTargetNodeList getDerived(Synset synset) throws JWNLException {
        return this.getPointerTargets(synset, PointerType.DERIVED);
    }

    public PointerTargetNodeList getSynonyms(Synset synset) throws JWNLException {
        return this.getPointerTargets(synset, PointerType.SIMILAR_TO);
    }

    public PointerTargetTree getSynonymTree(Synset synset, int depth) throws JWNLException {
        return new PointerTargetTree(synset, this.makePointerTargetTreeList(synset, PointerType.SIMILAR_TO, null, depth, false));
    }

    private PointerTargetNodeList getPointerTargets(Synset synset, PointerType type) throws JWNLException {
        return new PointerTargetNodeList(synset.getTargets(type));
    }

    public PointerTargetTreeNodeList makePointerTargetTreeList(Synset set, PointerType searchType) throws JWNLException {
        return this.makePointerTargetTreeList(set, searchType, Integer.MAX_VALUE);
    }

    public PointerTargetTreeNodeList makePointerTargetTreeList(Synset set, PointerType searchType, int depth) throws JWNLException {
        return this.makePointerTargetTreeList(set, searchType, null, depth, true);
    }

    public PointerTargetTreeNodeList makePointerTargetTreeList(Synset set, PointerType searchType, PointerType labelType, int depth, boolean allowRedundancies) throws JWNLException {
        PointerType[] searchTypes = new PointerType[]{searchType};
        return this.makePointerTargetTreeList(set, searchTypes, labelType, depth, allowRedundancies);
    }

    public PointerTargetTreeNodeList makePointerTargetTreeList(Synset set, PointerType[] searchTypes) throws JWNLException {
        return this.makePointerTargetTreeList(set, searchTypes, Integer.MAX_VALUE);
    }

    public PointerTargetTreeNodeList makePointerTargetTreeList(Synset set, PointerType[] searchTypes, int depth) throws JWNLException {
        return this.makePointerTargetTreeList(set, searchTypes, null, depth, true);
    }

    public PointerTargetTreeNodeList makePointerTargetTreeList(Synset synset, PointerType[] searchTypes, PointerType labelType, int depth, boolean allowRedundancies) throws JWNLException {
        return this.makePointerTargetTreeList(synset, searchTypes, labelType, depth, allowRedundancies, null);
    }

    public PointerTargetTreeNodeList makePointerTargetTreeList(PointerTargetNodeList list2, PointerType searchType, PointerType labelType, int depth, boolean allowRedundancies) throws JWNLException {
        PointerType[] searchTypes = new PointerType[]{searchType};
        return this.makePointerTargetTreeList(list2, searchTypes, labelType, depth, allowRedundancies);
    }

    public PointerTargetTreeNodeList makePointerTargetTreeList(PointerTargetNodeList list2, PointerType[] searchTypes, PointerType labelType, int depth, boolean allowRedundancies) throws JWNLException {
        PointerTargetTreeNodeList treeList = new PointerTargetTreeNodeList();
        for (PointerTargetNode node : list2) {
            treeList.add(node.getPointerTarget(), this.makePointerTargetTreeList(node.getSynset(), searchTypes, labelType, depth, allowRedundancies), labelType);
        }
        return treeList;
    }

    private PointerTargetTreeNodeList makePointerTargetTreeList(Synset synset, PointerType[] searchTypes, PointerType labelType, int depth, boolean allowRedundancies, PointerTargetTreeNode parent) throws JWNLException {
        --depth;
        PointerTargetTreeNodeList list2 = new PointerTargetTreeNodeList();
        for (int i = 0; i < searchTypes.length; ++i) {
            PointerType type = searchTypes[i];
            PointerTargetNodeList targets = new PointerTargetNodeList(synset.getTargets(type));
            if (targets.size() <= 0) continue;
            for (PointerTargetNode ptr : targets) {
                ptr.getSynset();
                PointerTargetTreeNode node = new PointerTargetTreeNode(ptr.getPointerTarget(), labelType == null ? type : labelType, parent);
                if (!allowRedundancies && list2.contains(node)) continue;
                if (depth != 0) {
                    node.setChildTreeList(this.makePointerTargetTreeList(node.getSynset(), searchTypes, labelType, depth, allowRedundancies, node));
                }
                list2.add(node);
            }
        }
        return list2;
    }

    public PointerTargetTree makeInheritedTree(Synset synset, PointerType searchType) throws JWNLException {
        return this.makeInheritedTree(synset, searchType, null, Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    public PointerTargetTree makeInheritedTree(Synset synset, PointerType searchType, PointerType labelType, int pointerDepth, int ancestorDepth) throws JWNLException {
        return this.makeInheritedTree(synset, searchType, labelType, pointerDepth, ancestorDepth, true);
    }

    public PointerTargetTree makeInheritedTree(Synset synset, PointerType searchType, PointerType labelType, int pointerDepth, int ancestorDepth, boolean allowRedundancies) throws JWNLException {
        PointerType[] searchTypes = new PointerType[]{searchType};
        return this.makeInheritedTree(synset, searchTypes, labelType, pointerDepth, ancestorDepth, allowRedundancies);
    }

    public PointerTargetTree makeInheritedTree(Synset synset, PointerType[] searchTypes) throws JWNLException {
        return this.makeInheritedTree(synset, searchTypes, null, Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    public PointerTargetTree makeInheritedTree(Synset synset, PointerType[] searchTypes, PointerType labelType, int pointerDepth, int ancestorDepth) throws JWNLException {
        return this.makeInheritedTree(synset, searchTypes, labelType, pointerDepth, ancestorDepth, true);
    }

    public PointerTargetTree makeInheritedTree(Synset synset, PointerType[] searchTypes, PointerType labelType, int pointerDepth, int ancestorDepth, boolean allowRedundancies) throws JWNLException {
        PointerTargetTree hypernyms = this.getHypernymTree(synset, Integer.MAX_VALUE);
        return this.makeInheritedTree(hypernyms, searchTypes, labelType, pointerDepth, ancestorDepth, allowRedundancies);
    }

    public PointerTargetTree makeInheritedTree(PointerTargetTree tree, PointerType[] searchTypes, PointerType labelType, int pointerDepth, int ancestorDepth, boolean allowRedundancies) throws JWNLException {
        PointerTargetTreeNode root2 = tree.getRootNode();
        root2.setPointerTreeList(this.makePointerTargetTreeList(root2.getSynset(), searchTypes, labelType, pointerDepth, allowRedundancies));
        root2.setChildTreeList(this.makeInheritedTreeList(root2.getChildTreeList(), searchTypes, labelType, pointerDepth, ancestorDepth, allowRedundancies));
        return new PointerTargetTree(root2);
    }

    public PointerTargetTreeNodeList makeInheritedTreeList(PointerTargetTreeNodeList list2, PointerType[] searchTypes, PointerType labelType, int pointerDepth, int ancestorDepth, boolean allowRedundancies) throws JWNLException {
        --ancestorDepth;
        PointerTargetTreeNodeList inherited = new PointerTargetTreeNodeList();
        for (PointerTargetTreeNode node : list2) {
            if (!allowRedundancies && inherited.contains(node)) continue;
            if (ancestorDepth == 0) {
                inherited.add(node.getPointerTarget(), null, this.makePointerTargetTreeList(node.getSynset(), searchTypes, labelType, pointerDepth, allowRedundancies), PointerType.HYPERNYM);
                continue;
            }
            inherited.add(node.getPointerTarget(), this.makeInheritedTreeList(node.getChildTreeList(), searchTypes, labelType, pointerDepth, ancestorDepth, allowRedundancies), this.makePointerTargetTreeList(node.getSynset(), searchTypes, labelType, pointerDepth, allowRedundancies), PointerType.HYPERNYM);
        }
        return inherited;
    }
}

