/*
 * Decompiled with CFR 0.152.
 */
package javax.wsdl.factory;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import javax.wsdl.Definition;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ExtensionRegistry;
import javax.wsdl.xml.WSDLReader;
import javax.wsdl.xml.WSDLWriter;

public abstract class WSDLFactory {
    private static final String PROPERTY_NAME = "javax.wsdl.factory.WSDLFactory";
    private static final String PROPERTY_FILE_NAME = "wsdl.properties";
    private static final String DEFAULT_FACTORY_IMPL_NAME = "com.ibm.wsdl.factory.WSDLFactoryImpl";
    private static String fullPropertyFileName = null;

    public static WSDLFactory newInstance() throws WSDLException {
        String string2 = WSDLFactory.findFactoryImplName();
        return WSDLFactory.newInstance(string2);
    }

    public static WSDLFactory newInstance(String string2) throws WSDLException {
        if (string2 != null) {
            try {
                Class<?> clazz = Class.forName(string2);
                return (WSDLFactory)clazz.newInstance();
            }
            catch (Exception exception) {
                throw new WSDLException("CONFIGURATION_ERROR", "Problem instantiating factory implementation.", exception);
            }
        }
        throw new WSDLException("CONFIGURATION_ERROR", "Unable to find name of factory implementation.");
    }

    public abstract Definition newDefinition();

    public abstract WSDLReader newWSDLReader();

    public abstract WSDLWriter newWSDLWriter();

    public abstract ExtensionRegistry newPopulatedExtensionRegistry();

    private static String findFactoryImplName() {
        String string2 = null;
        try {
            string2 = System.getProperty(PROPERTY_NAME);
            if (string2 != null) {
                return string2;
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        String string3 = WSDLFactory.getFullPropertyFileName();
        if (string3 != null) {
            try {
                Properties properties = new Properties();
                File file = new File(string3);
                FileInputStream fileInputStream = new FileInputStream(file);
                properties.load(fileInputStream);
                fileInputStream.close();
                string2 = properties.getProperty(PROPERTY_NAME);
                if (string2 != null) {
                    return string2;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return DEFAULT_FACTORY_IMPL_NAME;
    }

    private static String getFullPropertyFileName() {
        if (fullPropertyFileName == null) {
            try {
                String string2 = System.getProperty("java.home");
                fullPropertyFileName = string2 + File.separator + "lib" + File.separator + PROPERTY_FILE_NAME;
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        return fullPropertyFileName;
    }
}

