/*
 * Decompiled with CFR 0.152.
 */
package gnu.trove.decorator;

import gnu.trove.TShortLongHashMap;
import gnu.trove.TShortLongIterator;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TShortLongHashMapDecorator
extends AbstractMap<Short, Long>
implements Map<Short, Long>,
Cloneable {
    protected TShortLongHashMap _map;

    public TShortLongHashMapDecorator(TShortLongHashMap map2) {
        this._map = map2;
    }

    public TShortLongHashMap getMap() {
        return this._map;
    }

    @Override
    public TShortLongHashMapDecorator clone() {
        try {
            TShortLongHashMapDecorator copy = (TShortLongHashMapDecorator)super.clone();
            copy._map = (TShortLongHashMap)this._map.clone();
            return copy;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    @Override
    public Long put(Short key, Long value2) {
        return this.wrapValue(this._map.put(this.unwrapKey(key), this.unwrapValue(value2)));
    }

    @Override
    public boolean equals(Object other) {
        if (this._map.equals(other)) {
            return true;
        }
        if (other instanceof Map) {
            Map that = (Map)other;
            if (that.size() != this._map.size()) {
                return false;
            }
            Iterator it = that.entrySet().iterator();
            int i = that.size();
            while (i-- > 0) {
                Map.Entry e = it.next();
                Object key = e.getKey();
                Object val = e.getValue();
                if (key instanceof Short && val instanceof Long) {
                    short k = this.unwrapKey(key);
                    long v = this.unwrapValue(val);
                    if (this._map.containsKey(k) && v == this._map.get(k)) continue;
                    return false;
                }
                return false;
            }
            return true;
        }
        return false;
    }

    public Long get(Short key) {
        short k = this.unwrapKey(key);
        long v = this._map.get(k);
        if (v == 0L) {
            return this._map.containsKey(k) ? this.wrapValue(v) : null;
        }
        return this.wrapValue(v);
    }

    @Override
    public void clear() {
        this._map.clear();
    }

    public Long remove(Short key) {
        return this.wrapValue(this._map.remove(this.unwrapKey(key)));
    }

    @Override
    public Set<Map.Entry<Short, Long>> entrySet() {
        return new AbstractSet<Map.Entry<Short, Long>>(){

            @Override
            public int size() {
                return TShortLongHashMapDecorator.this._map.size();
            }

            @Override
            public boolean isEmpty() {
                return TShortLongHashMapDecorator.this.isEmpty();
            }

            @Override
            public boolean contains(Object o) {
                if (o instanceof Map.Entry) {
                    Object k = ((Map.Entry)o).getKey();
                    Object v = ((Map.Entry)o).getValue();
                    return TShortLongHashMapDecorator.this.containsKey(k) && ((Long)TShortLongHashMapDecorator.this.get(k)).equals(v);
                }
                return false;
            }

            @Override
            public Iterator<Map.Entry<Short, Long>> iterator() {
                return new Iterator<Map.Entry<Short, Long>>(){
                    private final TShortLongIterator it;
                    {
                        this.it = TShortLongHashMapDecorator.this._map.iterator();
                    }

                    @Override
                    public Map.Entry<Short, Long> next() {
                        this.it.advance();
                        final Short key = TShortLongHashMapDecorator.this.wrapKey(this.it.key());
                        final Long v = TShortLongHashMapDecorator.this.wrapValue(this.it.value());
                        return new Map.Entry<Short, Long>(){
                            private Long val;
                            {
                                this.val = v;
                            }

                            @Override
                            public boolean equals(Object o) {
                                return o instanceof Map.Entry && ((Map.Entry)o).getKey().equals(key) && ((Map.Entry)o).getValue().equals(this.val);
                            }

                            @Override
                            public Short getKey() {
                                return key;
                            }

                            @Override
                            public Long getValue() {
                                return this.val;
                            }

                            @Override
                            public int hashCode() {
                                return key.hashCode() + this.val.hashCode();
                            }

                            @Override
                            public Long setValue(Long value2) {
                                this.val = value2;
                                return TShortLongHashMapDecorator.this.put(key, value2);
                            }
                        };
                    }

                    @Override
                    public boolean hasNext() {
                        return this.it.hasNext();
                    }

                    @Override
                    public void remove() {
                        this.it.remove();
                    }
                };
            }

            @Override
            public boolean add(Long o) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean remove(Object o) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean addAll(Collection<? extends Map.Entry<Short, Long>> c) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean retainAll(Collection<?> c) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean removeAll(Collection<?> c) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void clear() {
                TShortLongHashMapDecorator.this.clear();
            }
        };
    }

    @Override
    public boolean containsValue(Object val) {
        return this._map.containsValue(this.unwrapValue(val));
    }

    @Override
    public boolean containsKey(Object key) {
        return this._map.containsKey(this.unwrapKey(key));
    }

    @Override
    public int size() {
        return this._map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public void putAll(Map<? extends Short, ? extends Long> map2) {
        Iterator<Map.Entry<? extends Short, ? extends Long>> it = map2.entrySet().iterator();
        int i = map2.size();
        while (i-- > 0) {
            Map.Entry<? extends Short, ? extends Long> e = it.next();
            this.put(e.getKey(), e.getValue());
        }
    }

    protected Short wrapKey(short k) {
        return new Short(k);
    }

    protected short unwrapKey(Object key) {
        return (Short)key;
    }

    protected Long wrapValue(long k) {
        return new Long(k);
    }

    protected long unwrapValue(Object value2) {
        return (Long)value2;
    }
}

