/*
 * Decompiled with CFR 0.152.
 */
package gnu.trove.decorator;

import gnu.trove.TByteShortHashMap;
import gnu.trove.TByteShortIterator;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TByteShortHashMapDecorator
extends AbstractMap<Byte, Short>
implements Map<Byte, Short>,
Cloneable {
    protected TByteShortHashMap _map;

    public TByteShortHashMapDecorator(TByteShortHashMap map2) {
        this._map = map2;
    }

    public TByteShortHashMap getMap() {
        return this._map;
    }

    @Override
    public TByteShortHashMapDecorator clone() {
        try {
            TByteShortHashMapDecorator copy = (TByteShortHashMapDecorator)super.clone();
            copy._map = (TByteShortHashMap)this._map.clone();
            return copy;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    @Override
    public Short put(Byte key, Short value2) {
        return this.wrapValue(this._map.put(this.unwrapKey(key), this.unwrapValue(value2)));
    }

    @Override
    public boolean equals(Object other) {
        if (this._map.equals(other)) {
            return true;
        }
        if (other instanceof Map) {
            Map that = (Map)other;
            if (that.size() != this._map.size()) {
                return false;
            }
            Iterator it = that.entrySet().iterator();
            int i = that.size();
            while (i-- > 0) {
                Map.Entry e = it.next();
                Object key = e.getKey();
                Object val = e.getValue();
                if (key instanceof Byte && val instanceof Short) {
                    byte k = this.unwrapKey(key);
                    short v = this.unwrapValue(val);
                    if (this._map.containsKey(k) && v == this._map.get(k)) continue;
                    return false;
                }
                return false;
            }
            return true;
        }
        return false;
    }

    public Short get(Byte key) {
        byte k = this.unwrapKey(key);
        short v = this._map.get(k);
        if (v == 0) {
            return this._map.containsKey(k) ? this.wrapValue(v) : null;
        }
        return this.wrapValue(v);
    }

    @Override
    public void clear() {
        this._map.clear();
    }

    public Short remove(Byte key) {
        return this.wrapValue(this._map.remove(this.unwrapKey(key)));
    }

    @Override
    public Set<Map.Entry<Byte, Short>> entrySet() {
        return new AbstractSet<Map.Entry<Byte, Short>>(){

            @Override
            public int size() {
                return TByteShortHashMapDecorator.this._map.size();
            }

            @Override
            public boolean isEmpty() {
                return TByteShortHashMapDecorator.this.isEmpty();
            }

            @Override
            public boolean contains(Object o) {
                if (o instanceof Map.Entry) {
                    Object k = ((Map.Entry)o).getKey();
                    Object v = ((Map.Entry)o).getValue();
                    return TByteShortHashMapDecorator.this.containsKey(k) && ((Short)TByteShortHashMapDecorator.this.get(k)).equals(v);
                }
                return false;
            }

            @Override
            public Iterator<Map.Entry<Byte, Short>> iterator() {
                return new Iterator<Map.Entry<Byte, Short>>(){
                    private final TByteShortIterator it;
                    {
                        this.it = TByteShortHashMapDecorator.this._map.iterator();
                    }

                    @Override
                    public Map.Entry<Byte, Short> next() {
                        this.it.advance();
                        final Byte key = TByteShortHashMapDecorator.this.wrapKey(this.it.key());
                        final Short v = TByteShortHashMapDecorator.this.wrapValue(this.it.value());
                        return new Map.Entry<Byte, Short>(){
                            private Short val;
                            {
                                this.val = v;
                            }

                            @Override
                            public boolean equals(Object o) {
                                return o instanceof Map.Entry && ((Map.Entry)o).getKey().equals(key) && ((Map.Entry)o).getValue().equals(this.val);
                            }

                            @Override
                            public Byte getKey() {
                                return key;
                            }

                            @Override
                            public Short getValue() {
                                return this.val;
                            }

                            @Override
                            public int hashCode() {
                                return key.hashCode() + this.val.hashCode();
                            }

                            @Override
                            public Short setValue(Short value2) {
                                this.val = value2;
                                return TByteShortHashMapDecorator.this.put(key, value2);
                            }
                        };
                    }

                    @Override
                    public boolean hasNext() {
                        return this.it.hasNext();
                    }

                    @Override
                    public void remove() {
                        this.it.remove();
                    }
                };
            }

            @Override
            public boolean add(Short o) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean remove(Object o) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean addAll(Collection<? extends Map.Entry<Byte, Short>> c) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean retainAll(Collection<?> c) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean removeAll(Collection<?> c) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void clear() {
                TByteShortHashMapDecorator.this.clear();
            }
        };
    }

    @Override
    public boolean containsValue(Object val) {
        return this._map.containsValue(this.unwrapValue(val));
    }

    @Override
    public boolean containsKey(Object key) {
        return this._map.containsKey(this.unwrapKey(key));
    }

    @Override
    public int size() {
        return this._map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public void putAll(Map<? extends Byte, ? extends Short> map2) {
        Iterator<Map.Entry<? extends Byte, ? extends Short>> it = map2.entrySet().iterator();
        int i = map2.size();
        while (i-- > 0) {
            Map.Entry<? extends Byte, ? extends Short> e = it.next();
            this.put(e.getKey(), e.getValue());
        }
    }

    protected Byte wrapKey(byte k) {
        return new Byte(k);
    }

    protected byte unwrapKey(Object key) {
        return (Byte)key;
    }

    protected Short wrapValue(short k) {
        return new Short(k);
    }

    protected short unwrapValue(Object value2) {
        return (Short)value2;
    }
}

