/*
 * Decompiled with CFR 0.152.
 */
package gnu.trove;

import gnu.trove.SerializationProcedure;
import gnu.trove.TFloatFunction;
import gnu.trove.TFloatProcedure;
import gnu.trove.TObjectFloatIterator;
import gnu.trove.TObjectFloatProcedure;
import gnu.trove.TObjectHash;
import gnu.trove.TObjectHashingStrategy;
import gnu.trove.TObjectProcedure;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Array;
import java.util.Arrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TObjectFloatHashMap<K>
extends TObjectHash<K>
implements Externalizable {
    static final long serialVersionUID = 1L;
    protected transient float[] _values;

    public TObjectFloatHashMap() {
    }

    public TObjectFloatHashMap(int initialCapacity) {
        super(initialCapacity);
    }

    public TObjectFloatHashMap(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
    }

    public TObjectFloatHashMap(TObjectHashingStrategy<K> strategy) {
        super(strategy);
    }

    public TObjectFloatHashMap(int initialCapacity, TObjectHashingStrategy<K> strategy) {
        super(initialCapacity, strategy);
    }

    public TObjectFloatHashMap(int initialCapacity, float loadFactor, TObjectHashingStrategy<K> strategy) {
        super(initialCapacity, loadFactor, strategy);
    }

    public TObjectFloatIterator<K> iterator() {
        return new TObjectFloatIterator(this);
    }

    @Override
    protected int setUp(int initialCapacity) {
        int capacity = super.setUp(initialCapacity);
        this._values = new float[capacity];
        return capacity;
    }

    public float put(K key, float value2) {
        float previous = 0.0f;
        int index = this.insertionIndex(key);
        boolean isNewMapping = true;
        if (index < 0) {
            index = -index - 1;
            previous = this._values[index];
            isNewMapping = false;
        }
        Object oldKey = this._set[index];
        this._set[index] = key;
        this._values[index] = value2;
        if (isNewMapping) {
            this.postInsertHook(oldKey == FREE);
        }
        return previous;
    }

    @Override
    protected void rehash(int newCapacity) {
        int oldCapacity = this._set.length;
        Object[] oldKeys = this._set;
        float[] oldVals = this._values;
        this._set = new Object[newCapacity];
        Arrays.fill(this._set, FREE);
        this._values = new float[newCapacity];
        int i = oldCapacity;
        while (i-- > 0) {
            if (oldKeys[i] == FREE || oldKeys[i] == REMOVED) continue;
            Object o = oldKeys[i];
            int index = this.insertionIndex(o);
            if (index < 0) {
                this.throwObjectContractViolation(this._set[-index - 1], o);
            }
            this._set[index] = o;
            this._values[index] = oldVals[i];
        }
    }

    public float get(K key) {
        int index = this.index(key);
        return index < 0 ? 0.0f : this._values[index];
    }

    @Override
    public void clear() {
        super.clear();
        Object[] keys = this._set;
        float[] vals = this._values;
        int i = keys.length;
        while (i-- > 0) {
            keys[i] = FREE;
            vals[i] = 0.0f;
        }
    }

    public float remove(K key) {
        float prev = 0.0f;
        int index = this.index(key);
        if (index >= 0) {
            prev = this._values[index];
            this.removeAt(index);
        }
        return prev;
    }

    public boolean equals(Object other) {
        if (!(other instanceof TObjectFloatHashMap)) {
            return false;
        }
        TObjectFloatHashMap that = (TObjectFloatHashMap)other;
        if (that.size() != this.size()) {
            return false;
        }
        return this.forEachEntry(new EqProcedure(that));
    }

    @Override
    public TObjectFloatHashMap<K> clone() {
        TObjectFloatHashMap clone2 = (TObjectFloatHashMap)super.clone();
        clone2._values = new float[this._values.length];
        for (int i = 0; i < clone2._values.length; ++i) {
            clone2._values[i] = this._values[i];
        }
        return clone2;
    }

    @Override
    protected void removeAt(int index) {
        this._values[index] = 0.0f;
        super.removeAt(index);
    }

    public float[] getValues() {
        float[] vals = new float[this.size()];
        float[] v = this._values;
        Object[] keys = this._set;
        int i = v.length;
        int j = 0;
        while (i-- > 0) {
            if (keys[i] == FREE || keys[i] == REMOVED) continue;
            vals[j++] = v[i];
        }
        return vals;
    }

    public Object[] keys() {
        Object[] keys = new Object[this.size()];
        Object[] k = this._set;
        int i = k.length;
        int j = 0;
        while (i-- > 0) {
            if (k[i] == FREE || k[i] == REMOVED) continue;
            keys[j++] = k[i];
        }
        return keys;
    }

    public K[] keys(K[] a) {
        int size2 = this.size();
        if (a.length < size2) {
            a = (Object[])Array.newInstance(a.getClass().getComponentType(), size2);
        }
        Object[] k = this._set;
        int i = k.length;
        int j = 0;
        while (i-- > 0) {
            if (k[i] == FREE || k[i] == REMOVED) continue;
            a[j++] = k[i];
        }
        return a;
    }

    public boolean containsValue(float val) {
        Object[] keys = this._set;
        float[] vals = this._values;
        int i = vals.length;
        while (i-- > 0) {
            if (keys[i] == FREE || keys[i] == REMOVED || val != vals[i]) continue;
            return true;
        }
        return false;
    }

    public boolean containsKey(K key) {
        return this.contains(key);
    }

    public boolean forEachKey(TObjectProcedure<K> procedure) {
        return this.forEach(procedure);
    }

    public boolean forEachValue(TFloatProcedure procedure) {
        Object[] keys = this._set;
        float[] values2 = this._values;
        int i = values2.length;
        while (i-- > 0) {
            if (keys[i] == FREE || keys[i] == REMOVED || procedure.execute(values2[i])) continue;
            return false;
        }
        return true;
    }

    public boolean forEachEntry(TObjectFloatProcedure<K> procedure) {
        Object[] keys = this._set;
        float[] values2 = this._values;
        int i = keys.length;
        while (i-- > 0) {
            if (keys[i] == FREE || keys[i] == REMOVED || procedure.execute(keys[i], values2[i])) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean retainEntries(TObjectFloatProcedure<K> procedure) {
        boolean modified = false;
        Object[] keys = this._set;
        float[] values2 = this._values;
        this.tempDisableAutoCompaction();
        try {
            int i = keys.length;
            while (i-- > 0) {
                if (keys[i] == FREE || keys[i] == REMOVED || procedure.execute(keys[i], values2[i])) continue;
                this.removeAt(i);
                modified = true;
            }
        }
        finally {
            this.reenableAutoCompaction(true);
        }
        return modified;
    }

    public void transformValues(TFloatFunction function) {
        Object[] keys = this._set;
        float[] values2 = this._values;
        int i = values2.length;
        while (i-- > 0) {
            if (keys[i] == null || keys[i] == REMOVED) continue;
            values2[i] = function.execute(values2[i]);
        }
    }

    public boolean increment(K key) {
        return this.adjustValue(key, 1.0f);
    }

    public boolean adjustValue(K key, float amount) {
        int index = this.index(key);
        if (index < 0) {
            return false;
        }
        int n = index;
        this._values[n] = this._values[n] + amount;
        return true;
    }

    public float adjustOrPutValue(K key, float adjust_amount, float put_amount) {
        boolean isNewMapping;
        float newValue;
        int index = this.insertionIndex(key);
        if (index < 0) {
            int n = index = -index - 1;
            float f2 = this._values[n] + adjust_amount;
            this._values[n] = f2;
            newValue = f2;
            isNewMapping = false;
        } else {
            newValue = this._values[index] = put_amount;
            isNewMapping = true;
        }
        Object oldKey = this._set[index];
        this._set[index] = key;
        if (isNewMapping) {
            this.postInsertHook(oldKey == FREE);
        }
        return newValue;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeByte(0);
        out.writeInt(this._size);
        SerializationProcedure writeProcedure = new SerializationProcedure(out);
        if (!this.forEachEntry(writeProcedure)) {
            throw writeProcedure.exception;
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        in.readByte();
        int size2 = in.readInt();
        this.setUp(size2);
        while (size2-- > 0) {
            Object key = in.readObject();
            float val = in.readFloat();
            this.put(key, val);
        }
    }

    private static final class EqProcedure
    implements TObjectFloatProcedure {
        private final TObjectFloatHashMap _otherMap;

        EqProcedure(TObjectFloatHashMap otherMap) {
            this._otherMap = otherMap;
        }

        public final boolean execute(Object key, float value2) {
            int index = this._otherMap.index(key);
            return index >= 0 && this.eq(value2, this._otherMap.get(key));
        }

        private final boolean eq(float v1, float v2) {
            return v1 == v2;
        }
    }
}

