/*
 * Decompiled with CFR 0.152.
 */
package gnu.trove;

import gnu.trove.HashFunctions;
import gnu.trove.TIntFunction;
import gnu.trove.TIntProcedure;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import java.util.Random;

public class TIntArrayList
implements Externalizable,
Cloneable {
    static final long serialVersionUID = 1L;
    protected int[] _data;
    protected int _pos;
    protected static final int DEFAULT_CAPACITY = 10;

    public TIntArrayList() {
        this(10);
    }

    public TIntArrayList(int capacity) {
        this._data = new int[capacity];
        this._pos = 0;
    }

    public TIntArrayList(int[] values2) {
        this(Math.max(values2.length, 10));
        this.add(values2);
    }

    public void ensureCapacity(int capacity) {
        if (capacity > this._data.length) {
            int newCap = Math.max(this._data.length << 1, capacity);
            int[] tmp = new int[newCap];
            System.arraycopy(this._data, 0, tmp, 0, this._data.length);
            this._data = tmp;
        }
    }

    public int size() {
        return this._pos;
    }

    public boolean isEmpty() {
        return this._pos == 0;
    }

    public void trimToSize() {
        if (this._data.length > this.size()) {
            int[] tmp = new int[this.size()];
            this.toNativeArray(tmp, 0, tmp.length);
            this._data = tmp;
        }
    }

    public void add(int val) {
        this.ensureCapacity(this._pos + 1);
        this._data[this._pos++] = val;
    }

    public void add(int[] vals) {
        this.add(vals, 0, vals.length);
    }

    public void add(int[] vals, int offset, int length) {
        this.ensureCapacity(this._pos + length);
        System.arraycopy(vals, offset, this._data, this._pos, length);
        this._pos += length;
    }

    public void insert(int offset, int value2) {
        if (offset == this._pos) {
            this.add(value2);
            return;
        }
        this.ensureCapacity(this._pos + 1);
        System.arraycopy(this._data, offset, this._data, offset + 1, this._pos - offset);
        this._data[offset] = value2;
        ++this._pos;
    }

    public void insert(int offset, int[] values2) {
        this.insert(offset, values2, 0, values2.length);
    }

    public void insert(int offset, int[] values2, int valOffset, int len) {
        if (offset == this._pos) {
            this.add(values2, valOffset, len);
            return;
        }
        this.ensureCapacity(this._pos + len);
        System.arraycopy(this._data, offset, this._data, offset + len, this._pos - offset);
        System.arraycopy(values2, valOffset, this._data, offset, len);
        this._pos += len;
    }

    public int get(int offset) {
        if (offset >= this._pos) {
            throw new ArrayIndexOutOfBoundsException(offset);
        }
        return this._data[offset];
    }

    public int getQuick(int offset) {
        return this._data[offset];
    }

    public void set(int offset, int val) {
        if (offset >= this._pos) {
            throw new ArrayIndexOutOfBoundsException(offset);
        }
        this._data[offset] = val;
    }

    public int getSet(int offset, int val) {
        if (offset >= this._pos) {
            throw new ArrayIndexOutOfBoundsException(offset);
        }
        int old = this._data[offset];
        this._data[offset] = val;
        return old;
    }

    public void set(int offset, int[] values2) {
        this.set(offset, values2, 0, values2.length);
    }

    public void set(int offset, int[] values2, int valOffset, int length) {
        if (offset < 0 || offset + length > this._pos) {
            throw new ArrayIndexOutOfBoundsException(offset);
        }
        System.arraycopy(values2, valOffset, this._data, offset, length);
    }

    public void setQuick(int offset, int val) {
        this._data[offset] = val;
    }

    public void clear() {
        this.clear(10);
    }

    public void clear(int capacity) {
        this._data = new int[capacity];
        this._pos = 0;
    }

    public void reset() {
        this._pos = 0;
        this.fill(0);
    }

    public void resetQuick() {
        this._pos = 0;
    }

    public int remove(int offset) {
        int old = this.get(offset);
        this.remove(offset, 1);
        return old;
    }

    public void remove(int offset, int length) {
        if (offset < 0 || offset >= this._pos) {
            throw new ArrayIndexOutOfBoundsException(offset);
        }
        if (offset == 0) {
            System.arraycopy(this._data, length, this._data, 0, this._pos - length);
        } else if (this._pos - length != offset) {
            System.arraycopy(this._data, offset + length, this._data, offset, this._pos - (offset + length));
        }
        this._pos -= length;
    }

    public void transformValues(TIntFunction function) {
        int i = this._pos;
        while (i-- > 0) {
            this._data[i] = function.execute(this._data[i]);
        }
    }

    public void reverse() {
        this.reverse(0, this._pos);
    }

    public void reverse(int from2, int to2) {
        if (from2 == to2) {
            return;
        }
        if (from2 > to2) {
            throw new IllegalArgumentException("from cannot be greater than to");
        }
        int i = from2;
        for (int j = to2 - 1; i < j; ++i, --j) {
            this.swap(i, j);
        }
    }

    public void shuffle(Random rand) {
        int i = this._pos;
        while (i-- > 1) {
            this.swap(i, rand.nextInt(i));
        }
    }

    private final void swap(int i, int j) {
        int tmp = this._data[i];
        this._data[i] = this._data[j];
        this._data[j] = tmp;
    }

    public Object clone() {
        TIntArrayList list2 = null;
        try {
            list2 = (TIntArrayList)super.clone();
            list2._data = this.toNativeArray();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return list2;
    }

    public TIntArrayList subList(int begin, int end) {
        if (end < begin) {
            throw new IllegalArgumentException("end index " + end + " greater than begin index " + begin);
        }
        if (begin < 0) {
            throw new IndexOutOfBoundsException("begin index can not be < 0");
        }
        if (end > this._data.length) {
            throw new IndexOutOfBoundsException("end index < " + this._data.length);
        }
        TIntArrayList list2 = new TIntArrayList(end - begin);
        for (int i = begin; i < end; ++i) {
            list2.add(this._data[i]);
        }
        return list2;
    }

    public int[] toNativeArray() {
        return this.toNativeArray(0, this._pos);
    }

    public int[] toNativeArray(int offset, int len) {
        int[] rv = new int[len];
        this.toNativeArray(rv, offset, len);
        return rv;
    }

    public void toNativeArray(int[] dest, int offset, int len) {
        if (len == 0) {
            return;
        }
        if (offset < 0 || offset >= this._pos) {
            throw new ArrayIndexOutOfBoundsException(offset);
        }
        System.arraycopy(this._data, offset, dest, 0, len);
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof TIntArrayList) {
            TIntArrayList that = (TIntArrayList)other;
            if (that.size() != this.size()) {
                return false;
            }
            int i = this._pos;
            while (i-- > 0) {
                if (this._data[i] == that._data[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        int h = 0;
        int i = this._pos;
        while (i-- > 0) {
            h += HashFunctions.hash(this._data[i]);
        }
        return h;
    }

    public boolean forEach(TIntProcedure procedure) {
        for (int i = 0; i < this._pos; ++i) {
            if (procedure.execute(this._data[i])) continue;
            return false;
        }
        return true;
    }

    public boolean forEachDescending(TIntProcedure procedure) {
        int i = this._pos;
        while (i-- > 0) {
            if (procedure.execute(this._data[i])) continue;
            return false;
        }
        return true;
    }

    public void sort() {
        Arrays.sort(this._data, 0, this._pos);
    }

    public void sort(int fromIndex, int toIndex) {
        Arrays.sort(this._data, fromIndex, toIndex);
    }

    public void fill(int val) {
        Arrays.fill(this._data, 0, this._pos, val);
    }

    public void fill(int fromIndex, int toIndex, int val) {
        if (toIndex > this._pos) {
            this.ensureCapacity(toIndex);
            this._pos = toIndex;
        }
        Arrays.fill(this._data, fromIndex, toIndex, val);
    }

    public int binarySearch(int value2) {
        return this.binarySearch(value2, 0, this._pos);
    }

    public int binarySearch(int value2, int fromIndex, int toIndex) {
        if (fromIndex < 0) {
            throw new ArrayIndexOutOfBoundsException(fromIndex);
        }
        if (toIndex > this._pos) {
            throw new ArrayIndexOutOfBoundsException(toIndex);
        }
        int low = fromIndex;
        int high = toIndex - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            int midVal = this._data[mid];
            if (midVal < value2) {
                low = mid + 1;
                continue;
            }
            if (midVal > value2) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    public int indexOf(int value2) {
        return this.indexOf(0, value2);
    }

    public int indexOf(int offset, int value2) {
        for (int i = offset; i < this._pos; ++i) {
            if (this._data[i] != value2) continue;
            return i;
        }
        return -1;
    }

    public int lastIndexOf(int value2) {
        return this.lastIndexOf(this._pos, value2);
    }

    public int lastIndexOf(int offset, int value2) {
        int i = offset;
        while (i-- > 0) {
            if (this._data[i] != value2) continue;
            return i;
        }
        return -1;
    }

    public boolean contains(int value2) {
        return this.lastIndexOf(value2) >= 0;
    }

    public TIntArrayList grep(TIntProcedure condition) {
        TIntArrayList list2 = new TIntArrayList();
        for (int i = 0; i < this._pos; ++i) {
            if (!condition.execute(this._data[i])) continue;
            list2.add(this._data[i]);
        }
        return list2;
    }

    public TIntArrayList inverseGrep(TIntProcedure condition) {
        TIntArrayList list2 = new TIntArrayList();
        for (int i = 0; i < this._pos; ++i) {
            if (condition.execute(this._data[i])) continue;
            list2.add(this._data[i]);
        }
        return list2;
    }

    public int max() {
        if (this.size() == 0) {
            throw new IllegalStateException("cannot find maximum of an empty list");
        }
        int max2 = Integer.MIN_VALUE;
        for (int i = 0; i < this._pos; ++i) {
            if (this._data[i] <= max2) continue;
            max2 = this._data[i];
        }
        return max2;
    }

    public int min() {
        if (this.size() == 0) {
            throw new IllegalStateException("cannot find minimum of an empty list");
        }
        int min2 = Integer.MAX_VALUE;
        for (int i = 0; i < this._pos; ++i) {
            if (this._data[i] >= min2) continue;
            min2 = this._data[i];
        }
        return min2;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("{");
        int end = this._pos - 1;
        for (int i = 0; i < end; ++i) {
            buf.append(this._data[i]);
            buf.append(", ");
        }
        if (this.size() > 0) {
            buf.append(this._data[this._pos - 1]);
        }
        buf.append("}");
        return buf.toString();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeByte(0);
        out.writeInt(this._pos);
        int len = this._data.length;
        out.writeInt(len);
        for (int i = 0; i < len; ++i) {
            out.writeInt(this._data[i]);
        }
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        in.readByte();
        this._pos = in.readInt();
        int len = in.readInt();
        this._data = new int[len];
        for (int i = 0; i < len; ++i) {
            this._data[i] = in.readInt();
        }
    }
}

