/*
 * Decompiled with CFR 0.152.
 */
package gnu.trove;

import gnu.trove.HashFunctions;
import gnu.trove.TFloatFunction;
import gnu.trove.TFloatProcedure;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import java.util.Random;

public class TFloatArrayList
implements Externalizable,
Cloneable {
    static final long serialVersionUID = 1L;
    protected float[] _data;
    protected int _pos;
    protected static final int DEFAULT_CAPACITY = 10;

    public TFloatArrayList() {
        this(10);
    }

    public TFloatArrayList(int capacity) {
        this._data = new float[capacity];
        this._pos = 0;
    }

    public TFloatArrayList(float[] values2) {
        this(Math.max(values2.length, 10));
        this.add(values2);
    }

    public void ensureCapacity(int capacity) {
        if (capacity > this._data.length) {
            int newCap = Math.max(this._data.length << 1, capacity);
            float[] tmp = new float[newCap];
            System.arraycopy(this._data, 0, tmp, 0, this._data.length);
            this._data = tmp;
        }
    }

    public int size() {
        return this._pos;
    }

    public boolean isEmpty() {
        return this._pos == 0;
    }

    public void trimToSize() {
        if (this._data.length > this.size()) {
            float[] tmp = new float[this.size()];
            this.toNativeArray(tmp, 0, tmp.length);
            this._data = tmp;
        }
    }

    public void add(float val) {
        this.ensureCapacity(this._pos + 1);
        this._data[this._pos++] = val;
    }

    public void add(float[] vals) {
        this.add(vals, 0, vals.length);
    }

    public void add(float[] vals, int offset, int length) {
        this.ensureCapacity(this._pos + length);
        System.arraycopy(vals, offset, this._data, this._pos, length);
        this._pos += length;
    }

    public void insert(int offset, float value2) {
        if (offset == this._pos) {
            this.add(value2);
            return;
        }
        this.ensureCapacity(this._pos + 1);
        System.arraycopy(this._data, offset, this._data, offset + 1, this._pos - offset);
        this._data[offset] = value2;
        ++this._pos;
    }

    public void insert(int offset, float[] values2) {
        this.insert(offset, values2, 0, values2.length);
    }

    public void insert(int offset, float[] values2, int valOffset, int len) {
        if (offset == this._pos) {
            this.add(values2, valOffset, len);
            return;
        }
        this.ensureCapacity(this._pos + len);
        System.arraycopy(this._data, offset, this._data, offset + len, this._pos - offset);
        System.arraycopy(values2, valOffset, this._data, offset, len);
        this._pos += len;
    }

    public float get(int offset) {
        if (offset >= this._pos) {
            throw new ArrayIndexOutOfBoundsException(offset);
        }
        return this._data[offset];
    }

    public float getQuick(int offset) {
        return this._data[offset];
    }

    public void set(int offset, float val) {
        if (offset >= this._pos) {
            throw new ArrayIndexOutOfBoundsException(offset);
        }
        this._data[offset] = val;
    }

    public float getSet(int offset, float val) {
        if (offset >= this._pos) {
            throw new ArrayIndexOutOfBoundsException(offset);
        }
        float old = this._data[offset];
        this._data[offset] = val;
        return old;
    }

    public void set(int offset, float[] values2) {
        this.set(offset, values2, 0, values2.length);
    }

    public void set(int offset, float[] values2, int valOffset, int length) {
        if (offset < 0 || offset + length > this._pos) {
            throw new ArrayIndexOutOfBoundsException(offset);
        }
        System.arraycopy(values2, valOffset, this._data, offset, length);
    }

    public void setQuick(int offset, float val) {
        this._data[offset] = val;
    }

    public void clear() {
        this.clear(10);
    }

    public void clear(int capacity) {
        this._data = new float[capacity];
        this._pos = 0;
    }

    public void reset() {
        this._pos = 0;
        this.fill(0.0f);
    }

    public void resetQuick() {
        this._pos = 0;
    }

    public float remove(int offset) {
        float old = this.get(offset);
        this.remove(offset, 1);
        return old;
    }

    public void remove(int offset, int length) {
        if (offset < 0 || offset >= this._pos) {
            throw new ArrayIndexOutOfBoundsException(offset);
        }
        if (offset == 0) {
            System.arraycopy(this._data, length, this._data, 0, this._pos - length);
        } else if (this._pos - length != offset) {
            System.arraycopy(this._data, offset + length, this._data, offset, this._pos - (offset + length));
        }
        this._pos -= length;
    }

    public void transformValues(TFloatFunction function) {
        int i = this._pos;
        while (i-- > 0) {
            this._data[i] = function.execute(this._data[i]);
        }
    }

    public void reverse() {
        this.reverse(0, this._pos);
    }

    public void reverse(int from2, int to2) {
        if (from2 == to2) {
            return;
        }
        if (from2 > to2) {
            throw new IllegalArgumentException("from cannot be greater than to");
        }
        int i = from2;
        for (int j = to2 - 1; i < j; ++i, --j) {
            this.swap(i, j);
        }
    }

    public void shuffle(Random rand) {
        int i = this._pos;
        while (i-- > 1) {
            this.swap(i, rand.nextInt(i));
        }
    }

    private final void swap(int i, int j) {
        float tmp = this._data[i];
        this._data[i] = this._data[j];
        this._data[j] = tmp;
    }

    public Object clone() {
        TFloatArrayList list2 = null;
        try {
            list2 = (TFloatArrayList)super.clone();
            list2._data = this.toNativeArray();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return list2;
    }

    public TFloatArrayList subList(int begin, int end) {
        if (end < begin) {
            throw new IllegalArgumentException("end index " + end + " greater than begin index " + begin);
        }
        if (begin < 0) {
            throw new IndexOutOfBoundsException("begin index can not be < 0");
        }
        if (end > this._data.length) {
            throw new IndexOutOfBoundsException("end index < " + this._data.length);
        }
        TFloatArrayList list2 = new TFloatArrayList(end - begin);
        for (int i = begin; i < end; ++i) {
            list2.add(this._data[i]);
        }
        return list2;
    }

    public float[] toNativeArray() {
        return this.toNativeArray(0, this._pos);
    }

    public float[] toNativeArray(int offset, int len) {
        float[] rv = new float[len];
        this.toNativeArray(rv, offset, len);
        return rv;
    }

    public void toNativeArray(float[] dest, int offset, int len) {
        if (len == 0) {
            return;
        }
        if (offset < 0 || offset >= this._pos) {
            throw new ArrayIndexOutOfBoundsException(offset);
        }
        System.arraycopy(this._data, offset, dest, 0, len);
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof TFloatArrayList) {
            TFloatArrayList that = (TFloatArrayList)other;
            if (that.size() != this.size()) {
                return false;
            }
            int i = this._pos;
            while (i-- > 0) {
                if (this._data[i] == that._data[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        int h = 0;
        int i = this._pos;
        while (i-- > 0) {
            h += HashFunctions.hash(this._data[i]);
        }
        return h;
    }

    public boolean forEach(TFloatProcedure procedure) {
        for (int i = 0; i < this._pos; ++i) {
            if (procedure.execute(this._data[i])) continue;
            return false;
        }
        return true;
    }

    public boolean forEachDescending(TFloatProcedure procedure) {
        int i = this._pos;
        while (i-- > 0) {
            if (procedure.execute(this._data[i])) continue;
            return false;
        }
        return true;
    }

    public void sort() {
        Arrays.sort(this._data, 0, this._pos);
    }

    public void sort(int fromIndex, int toIndex) {
        Arrays.sort(this._data, fromIndex, toIndex);
    }

    public void fill(float val) {
        Arrays.fill(this._data, 0, this._pos, val);
    }

    public void fill(int fromIndex, int toIndex, float val) {
        if (toIndex > this._pos) {
            this.ensureCapacity(toIndex);
            this._pos = toIndex;
        }
        Arrays.fill(this._data, fromIndex, toIndex, val);
    }

    public int binarySearch(float value2) {
        return this.binarySearch(value2, 0, this._pos);
    }

    public int binarySearch(float value2, int fromIndex, int toIndex) {
        if (fromIndex < 0) {
            throw new ArrayIndexOutOfBoundsException(fromIndex);
        }
        if (toIndex > this._pos) {
            throw new ArrayIndexOutOfBoundsException(toIndex);
        }
        int low = fromIndex;
        int high = toIndex - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            float midVal = this._data[mid];
            if (midVal < value2) {
                low = mid + 1;
                continue;
            }
            if (midVal > value2) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    public int indexOf(float value2) {
        return this.indexOf(0, value2);
    }

    public int indexOf(int offset, float value2) {
        for (int i = offset; i < this._pos; ++i) {
            if (this._data[i] != value2) continue;
            return i;
        }
        return -1;
    }

    public int lastIndexOf(float value2) {
        return this.lastIndexOf(this._pos, value2);
    }

    public int lastIndexOf(int offset, float value2) {
        int i = offset;
        while (i-- > 0) {
            if (this._data[i] != value2) continue;
            return i;
        }
        return -1;
    }

    public boolean contains(float value2) {
        return this.lastIndexOf(value2) >= 0;
    }

    public TFloatArrayList grep(TFloatProcedure condition) {
        TFloatArrayList list2 = new TFloatArrayList();
        for (int i = 0; i < this._pos; ++i) {
            if (!condition.execute(this._data[i])) continue;
            list2.add(this._data[i]);
        }
        return list2;
    }

    public TFloatArrayList inverseGrep(TFloatProcedure condition) {
        TFloatArrayList list2 = new TFloatArrayList();
        for (int i = 0; i < this._pos; ++i) {
            if (condition.execute(this._data[i])) continue;
            list2.add(this._data[i]);
        }
        return list2;
    }

    public float max() {
        if (this.size() == 0) {
            throw new IllegalStateException("cannot find maximum of an empty list");
        }
        float max2 = Float.NEGATIVE_INFINITY;
        for (int i = 0; i < this._pos; ++i) {
            if (!(this._data[i] > max2)) continue;
            max2 = this._data[i];
        }
        return max2;
    }

    public float min() {
        if (this.size() == 0) {
            throw new IllegalStateException("cannot find minimum of an empty list");
        }
        float min2 = Float.POSITIVE_INFINITY;
        for (int i = 0; i < this._pos; ++i) {
            if (!(this._data[i] < min2)) continue;
            min2 = this._data[i];
        }
        return min2;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("{");
        int end = this._pos - 1;
        for (int i = 0; i < end; ++i) {
            buf.append(this._data[i]);
            buf.append(", ");
        }
        if (this.size() > 0) {
            buf.append(this._data[this._pos - 1]);
        }
        buf.append("}");
        return buf.toString();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeByte(0);
        out.writeInt(this._pos);
        int len = this._data.length;
        out.writeInt(len);
        for (int i = 0; i < len; ++i) {
            out.writeFloat(this._data[i]);
        }
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        in.readByte();
        this._pos = in.readInt();
        int len = in.readInt();
        this._data = new float[len];
        for (int i = 0; i < len; ++i) {
            this._data[i] = in.readFloat();
        }
    }
}

