/*
 * Decompiled with CFR 0.152.
 */
package dragon.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class SortedArray
extends ArrayList {
    private static final long serialVersionUID = 1L;
    private Comparator comparator;
    private int insertedPos;

    public SortedArray(int capacity, Comparator comparator) {
        super(capacity);
        this.comparator = comparator;
    }

    public SortedArray(int capacity) {
        super(capacity);
        this.comparator = null;
    }

    public SortedArray(Comparator comparator) {
        this.comparator = comparator;
    }

    public SortedArray() {
        this.comparator = null;
    }

    public int insertedPos() {
        return this.insertedPos;
    }

    public boolean add(Object key) {
        int pos = this.comparator == null ? Collections.binarySearch(this, key) : Collections.binarySearch(this, key, this.comparator);
        if (pos < 0) {
            this.insertedPos = pos * -1 - 1;
            super.add(this.insertedPos, key);
            return true;
        }
        this.insertedPos = pos;
        return false;
    }

    public int binarySearch(Object key) {
        if (this.comparator == null) {
            return Collections.binarySearch(this, key);
        }
        return Collections.binarySearch(this, key, this.comparator);
    }

    public int binarySearch(Object key, int start) {
        return SortedArray.binarySearch(this, key, start, this.size() - 1, this.comparator);
    }

    public int binarySearch(Object key, int start, int end) {
        return SortedArray.binarySearch(this, key, start, end, this.comparator);
    }

    public boolean contains(Object key) {
        int pos = this.comparator == null ? Collections.binarySearch(this, key) : Collections.binarySearch(this, key, this.comparator);
        return pos >= 0;
    }

    public SortedArray copy(Comparator comparator) {
        SortedArray newList = new SortedArray();
        newList.addAll(this);
        newList.setComparator(comparator);
        return newList;
    }

    public SortedArray copy() {
        return this.copy(null);
    }

    public Comparator getComparator() {
        return this.comparator;
    }

    public void setComparator(Comparator comparator) {
        this.comparator = comparator;
        if (comparator == null) {
            Collections.sort(this);
        } else {
            Collections.sort(this, comparator);
        }
    }

    public static int binarySearch(List list2, Object obj) {
        return SortedArray.binarySearch(list2, obj, 0, list2.size() - 1, null);
    }

    public static int binarySearch(List list2, Object obj, Comparator comparator) {
        return SortedArray.binarySearch(list2, obj, 0, list2.size() - 1, comparator);
    }

    public static int binarySearch(List list2, Object obj, int start, int end) {
        return SortedArray.binarySearch(list2, obj, start, end, null);
    }

    public static int binarySearch(List list2, Object obj, int start, int end, Comparator comparator) {
        while (start <= end) {
            int middle = (start + end) / 2;
            int retvalue = comparator == null ? ((Comparable)obj).compareTo(list2.get(middle)) : comparator.compare(obj, list2.get(middle));
            if (retvalue == 0) {
                return middle;
            }
            if (retvalue > 0) {
                start = middle + 1;
                continue;
            }
            end = middle - 1;
        }
        return -(start + 1);
    }
}

