/*
 * Decompiled with CFR 0.152.
 */
package dragon.util;

import dragon.util.EnvVariable;
import dragon.util.FileUtil;
import dragon.util.SortedArray;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;

public class SimpleDictionary {
    private SortedArray list;
    private boolean caseSensitive;

    public SimpleDictionary() {
        this(false);
    }

    public SimpleDictionary(boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
        this.list = new SortedArray();
    }

    public SimpleDictionary(String dictFile) {
        this(dictFile, false);
    }

    public SimpleDictionary(String dictFile, boolean caseSensitive) {
        this.list = SimpleDictionary.loadList(dictFile, caseSensitive);
        this.caseSensitive = caseSensitive;
    }

    public void add(String word) {
        if (this.caseSensitive) {
            this.list.add(word);
        } else {
            this.list.add(word.toLowerCase());
        }
    }

    public boolean exist(String word) {
        if (word == null) {
            return false;
        }
        if (this.caseSensitive) {
            return this.list.binarySearch(word) >= 0;
        }
        return this.list.binarySearch(word.toLowerCase()) >= 0;
    }

    public static void merge(String inputFolder, String outputFile, boolean caseSensitive) {
        File folder = new File(inputFolder);
        if (!folder.exists()) {
            return;
        }
        if (!folder.isDirectory()) {
            return;
        }
        File[] arrFile = folder.listFiles();
        SortedArray list2 = new SortedArray();
        int i = 0;
        while (i < arrFile.length) {
            SimpleDictionary.loadList(inputFolder + "/" + arrFile[i].getName(), list2, caseSensitive);
            ++i;
        }
        try {
            BufferedWriter bw = FileUtil.getTextWriter(outputFile);
            i = 0;
            while (i < list2.size()) {
                bw.write((String)list2.get(i) + "\n");
                ++i;
            }
            list2.clear();
            bw.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static SortedArray loadList(String filename, boolean caseSensitive) {
        SortedArray list2 = new SortedArray();
        SimpleDictionary.loadList(filename, list2, caseSensitive);
        return list2;
    }

    public static void loadList(String filename, SortedArray list2, boolean caseSensitive) {
        try {
            if (filename == null || filename.trim().length() == 0) {
                return;
            }
            if (!FileUtil.exist(filename) && FileUtil.exist(EnvVariable.getDragonHome() + "/" + filename)) {
                filename = EnvVariable.getDragonHome() + "/" + filename;
            }
            BufferedReader br = FileUtil.getTextReader(filename);
            String line = br.readLine().trim();
            try {
                Integer.parseInt(line);
                line = "";
            }
            catch (Exception e) {}
            while (line != null) {
                if ((line = line.trim()).length() == 0) {
                    line = br.readLine();
                    continue;
                }
                int pos = line.indexOf(9);
                if (pos > 0) {
                    line = line.substring(0, pos);
                }
                if (!caseSensitive) {
                    list2.add(line.toLowerCase());
                } else {
                    list2.add(line);
                }
                line = br.readLine();
            }
            br.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

