/*
 * Decompiled with CFR 0.152.
 */
package dragon.util;

public class MathUtil {
    public static double LOG0 = -1.7976931348623157E308;
    public static double LOG2 = 0.69314718055;
    private static final double MINUS_LOG_EPSILON = 30.0;

    public static void initArray(double[] array, double initVal) {
        int i = 0;
        while (i < array.length) {
            array[i] = initVal;
            ++i;
        }
    }

    public static void initArray(int[] array, int initVal) {
        int i = 0;
        while (i < array.length) {
            array[i] = initVal;
            ++i;
        }
    }

    public static void copyArray(double[] srcArray, double[] destArray) {
        int i = 0;
        while (i < srcArray.length) {
            destArray[i] = srcArray[i];
            ++i;
        }
    }

    public static void multiArray(double[] array, double multiplier) {
        int i = 0;
        while (i < array.length) {
            int n = i++;
            array[n] = array[n] * multiplier;
        }
    }

    public static double sumArray(double[] array) {
        double sum2 = 0.0;
        int i = 0;
        while (i < array.length) {
            sum2 += array[i];
            ++i;
        }
        return sum2;
    }

    public static int sumArray(int[] array) {
        int sum2 = 0;
        int i = 0;
        while (i < array.length) {
            sum2 += array[i];
            ++i;
        }
        return sum2;
    }

    public static void sumArray(double[] array, double[] incArray) {
        int i = 0;
        while (i < array.length) {
            int n = i;
            array[n] = array[n] + incArray[i];
            ++i;
        }
    }

    public static double max(double[] array) {
        double max2 = array[0];
        int i = 1;
        while (i < array.length) {
            if (array[i] > max2) {
                max2 = array[i];
            }
            ++i;
        }
        return max2;
    }

    public static int max(int[] array) {
        int max2 = array[0];
        int i = 1;
        while (i < array.length) {
            if (array[i] > max2) {
                max2 = array[i];
            }
            ++i;
        }
        return max2;
    }

    public static double min(double[] array) {
        double min2 = array[0];
        int i = 1;
        while (i < array.length) {
            if (array[i] < min2) {
                min2 = array[i];
            }
            ++i;
        }
        return min2;
    }

    public static int min(int[] array) {
        int min2 = array[0];
        int i = 1;
        while (i < array.length) {
            if (array[i] < min2) {
                min2 = array[i];
            }
            ++i;
        }
        return min2;
    }

    public static double average(double[] array) {
        double sum2 = 0.0;
        int i = 0;
        while (i < array.length) {
            sum2 += array[i];
            ++i;
        }
        return sum2 / (double)array.length;
    }

    public static double average(int[] array) {
        double sum2 = 0.0;
        int i = 0;
        while (i < array.length) {
            sum2 += (double)array[i];
            ++i;
        }
        return sum2 / (double)array.length;
    }

    public static int maxElementInArray(double[] array) {
        double max2 = array[0];
        int maxIndex = 0;
        int i = 1;
        while (i < array.length) {
            if (array[i] > max2) {
                max2 = array[i];
                maxIndex = i;
            }
            ++i;
        }
        return maxIndex;
    }

    public static int maxElementInArray(int[] array) {
        double max2 = array[0];
        int maxIndex = 0;
        int i = 1;
        while (i < array.length) {
            if ((double)array[i] > max2) {
                max2 = array[i];
                maxIndex = i;
            }
            ++i;
        }
        return maxIndex;
    }

    /*
     * Unable to fully structure code
     */
    public static int[] rankElementInArray(double[] array, boolean desc) {
        rank = new int[array.length];
        MathUtil.initArray(rank, -1);
        i = 0;
        while (i < array.length) {
            block5: {
                count = 0;
                j = 0;
                while (j < array.length) {
                    if (array[j] > array[i]) {
                        ++count;
                    }
                    ++j;
                }
                if (!desc) ** GOTO lbl19
                while (rank[count] >= 0) {
                    ++count;
                }
                rank[count] = i;
                break block5;
lbl-1000:
                // 1 sources

                {
                    ++count;
lbl19:
                    // 2 sources

                    ** while (rank[array.length - 1 - count] >= 0)
                }
lbl20:
                // 1 sources

                rank[array.length - 1 - count] = i;
            }
            ++i;
        }
        return rank;
    }

    /*
     * Unable to fully structure code
     */
    public static int[] rankElementInArray(int[] array, boolean desc) {
        rank = new int[array.length];
        MathUtil.initArray(rank, -1);
        i = 0;
        while (i < array.length) {
            block5: {
                count = 0;
                j = 0;
                while (j < array.length) {
                    if (array[j] > array[i]) {
                        ++count;
                    }
                    ++j;
                }
                if (!desc) ** GOTO lbl19
                while (rank[count] >= 0) {
                    ++count;
                }
                rank[count] = i;
                break block5;
lbl-1000:
                // 1 sources

                {
                    ++count;
lbl19:
                    // 2 sources

                    ** while (rank[array.length - 1 - count] >= 0)
                }
lbl20:
                // 1 sources

                rank[array.length - 1 - count] = i;
            }
            ++i;
        }
        return rank;
    }

    public static double exp(double d) {
        if (Double.isInfinite(d) || d < 0.0 && Math.abs(d) > 30.0) {
            return 0.0;
        }
        return Math.exp(d);
    }

    public static double log(double val) {
        return Math.abs(val - 1.0) < Double.MIN_VALUE ? 0.0 : Math.log(val);
    }

    public static double logSumExp(double v1, double v2) {
        if (Math.abs(v1 - v2) < Double.MIN_VALUE) {
            return v1 + LOG2;
        }
        double vmin = Math.min(v1, v2);
        double vmax = Math.max(v1, v2);
        if (vmax > vmin + 30.0) {
            return vmax;
        }
        return vmax + Math.log(Math.exp(vmin - vmax) + 1.0);
    }

    public static void logSumExp(double[] v1, double[] v2) {
        int i = 0;
        while (i < v1.length) {
            v1[i] = MathUtil.logSumExp(v1[i], v2[i]);
            ++i;
        }
    }

    public static double logSumExp(double[] logArray) {
        double ret = logArray[0];
        int i = 1;
        while (i < logArray.length) {
            ret = MathUtil.logSumExp(ret, logArray[i]);
            ++i;
        }
        return ret;
    }
}

