/*
 * Decompiled with CFR 0.152.
 */
package dragon.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;

public class FastFileInputStream
extends InputStream {
    private byte[] buf;
    private int buf_length;
    private int buf_pos;
    private long available;
    private FileInputStream fis;
    private RandomAccessFile raf;
    private int inputType;
    private boolean class_open_file;

    public FastFileInputStream(String filename) {
        try {
            File f2 = new File(filename);
            this.available = f2.length();
            this.fis = new FileInputStream(f2);
            this.raf = null;
            this.buf_length = 512;
            this.buf = new byte[this.buf_length];
            this.buf_pos = this.buf_length;
            this.inputType = 1;
            this.class_open_file = true;
        }
        catch (Exception e) {
            this.fis = null;
            e.printStackTrace();
        }
    }

    public FastFileInputStream(File f2) {
        try {
            this.available = f2.length();
            this.fis = new FileInputStream(f2);
            this.raf = null;
            this.buf_length = 512;
            this.buf = new byte[this.buf_length];
            this.buf_pos = this.buf_length;
            this.inputType = 1;
            this.class_open_file = true;
        }
        catch (Exception e) {
            this.fis = null;
            e.printStackTrace();
        }
    }

    public FastFileInputStream(RandomAccessFile raf, long length) {
        this.buf_length = 512;
        this.buf = new byte[this.buf_length];
        this.buf_pos = this.buf_length;
        this.raf = raf;
        this.fis = null;
        this.available = length;
        this.inputType = 2;
        this.class_open_file = false;
    }

    public int read() throws IOException {
        this.refillBuffer();
        if (this.available <= 0L) {
            return -1;
        }
        ++this.buf_pos;
        --this.available;
        return this.buf[this.buf_pos - 1] & 0xFF;
    }

    public int read(byte[] buffer) throws IOException {
        return this.read(buffer, 0, buffer.length);
    }

    public int read(byte[] buffer, int off, int len) throws IOException {
        this.refillBuffer();
        if (this.available <= 0L) {
            return -1;
        }
        int count2 = this.buf_length - this.buf_pos;
        if (this.available < (long)len) {
            len = (int)this.available;
        }
        if (len <= count2) {
            System.arraycopy(this.buf, this.buf_pos, buffer, off, len);
            this.buf_pos += len;
            this.available -= (long)len;
            return len;
        }
        System.arraycopy(this.buf, this.buf_pos, buffer, off, count2);
        this.buf_pos = this.buf_length;
        int left = this.internalRead(buffer, off + count2, len - count2);
        if (left <= 0) {
            this.available = 0L;
            return count2;
        }
        this.available -= (long)(count2 + left);
        return count2 + left;
    }

    public boolean markSupported() {
        return false;
    }

    public void mark(int readLimit) {
    }

    public void reset() {
    }

    public long skip(long n) throws IOException {
        int count2;
        if (this.available < n) {
            n = this.available;
        }
        if (n <= (long)(count2 = this.buf_length - this.buf_pos)) {
            this.buf_pos = (int)((long)this.buf_pos + n);
            this.available -= n;
            return n;
        }
        this.buf_pos = this.buf_length;
        long left = this.internalSkip(n - (long)count2);
        this.available = this.available - (long)count2 - left;
        return (long)count2 + left;
    }

    public int available() {
        return (int)this.available;
    }

    public long remaining() {
        return this.available;
    }

    public void close() throws IOException {
        if (this.class_open_file) {
            if (this.fis != null) {
                this.fis.close();
            }
            if (this.raf != null) {
                this.raf.close();
            }
        }
    }

    private void refillBuffer() {
        if (this.available <= 0L || this.buf_pos < this.buf_length) {
            return;
        }
        try {
            this.buf_length = this.internalRead(this.buf, 0, this.buf.length);
            this.buf_pos = 0;
        }
        catch (Exception e) {
            this.buf_length = 0;
            e.printStackTrace();
        }
    }

    private int internalRead(byte[] buffer, int off, int len) throws IOException {
        if (this.inputType == 1) {
            return this.fis.read(buffer, off, len);
        }
        return this.raf.read(buffer, off, len);
    }

    private long internalSkip(long n) throws IOException {
        if (this.inputType == 1) {
            return this.fis.skip(n);
        }
        return this.raf.skipBytes((int)n);
    }
}

