/*
 * Decompiled with CFR 0.152.
 */
package dragon.util;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.RandomAccessFile;

public class FastBinaryWriter
extends DataOutputStream {
    private static final int BUF_SIZE = 0x100000;
    private ByteArrayOutputStream baos;
    private DataOutputStream dos;
    private long offset;

    public FastBinaryWriter(String outputFile) {
        super(new ByteArrayOutputStream());
        this.baos = (ByteArrayOutputStream)this.out;
        try {
            this.dos = new DataOutputStream(new FileOutputStream(new File(outputFile)));
            this.offset = 0L;
        }
        catch (Exception e) {
            this.dos = null;
            e.printStackTrace();
        }
    }

    public FastBinaryWriter(String outputFile, boolean append2) {
        super(new ByteArrayOutputStream());
        this.baos = (ByteArrayOutputStream)this.out;
        File file = new File(outputFile);
        try {
            this.dos = new DataOutputStream(new FileOutputStream(file, append2));
            this.offset = file.length();
        }
        catch (Exception e) {
            this.dos = null;
            e.printStackTrace();
        }
    }

    public long getFilePointer() {
        return this.offset + (long)this.size();
    }

    public int bytesInBuffer() {
        return this.baos.size();
    }

    public void flush() {
        try {
            this.baos.writeTo(this.dos);
            this.baos.reset();
            this.dos.flush();
            super.flush();
        }
        catch (Exception e) {}
    }

    public void close() {
        try {
            this.flush();
            this.baos.close();
            this.dos.close();
            super.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void write(byte[] buf, int off, int len) {
        try {
            super.write(buf, off, len);
            if (this.baos.size() >= 0x100000) {
                this.flush();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void write(InputStream src, long length) {
        try {
            if (length <= 0L) {
                return;
            }
            byte[] buf = new byte[(int)(10240L < length ? 10240L : length)];
            while (length > 0L) {
                int count2 = (int)(length > (long)buf.length ? (long)buf.length : length);
                if ((count2 = src.read(buf, 0, count2)) > 0) {
                    this.write(buf, 0, count2);
                    length -= (long)count2;
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void write(RandomAccessFile src, long length) {
        try {
            byte[] buf = new byte[(int)(10240L < length ? 10240L : length)];
            while (length > 0L) {
                int count2 = (int)(length > (long)buf.length ? (long)buf.length : length);
                if ((count2 = src.read(buf, 0, count2)) > 0) {
                    this.write(buf, 0, count2);
                    length -= (long)count2;
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

