/*
 * Decompiled with CFR 0.152.
 */
package dragon.util;

public class ByteArrayConvert {
    public static final byte[] toByte(int i) {
        byte[] abyte0 = new byte[4];
        int byte0 = 0;
        while (byte0 <= 3) {
            abyte0[byte0] = (byte)(i >>> (3 - byte0) * 8);
            byte0 = (byte)(byte0 + 1);
        }
        return abyte0;
    }

    public static final void toByte(int i, byte[] abyte0, int offset) {
        int byte0 = 0;
        while (byte0 <= 3) {
            abyte0[byte0 + offset] = (byte)(i >>> (3 - byte0) * 8);
            byte0 = (byte)(byte0 + 1);
        }
    }

    public static final byte[] toByte(short word0) {
        byte[] abyte0 = new byte[2];
        int byte0 = 0;
        while (byte0 <= 1) {
            abyte0[byte0] = (byte)(word0 >>> (1 - byte0) * 8);
            byte0 = (byte)(byte0 + 1);
        }
        return abyte0;
    }

    public static final void toByte(short word0, byte[] abyte0, int offset) {
        int byte0 = 0;
        while (byte0 <= 1) {
            abyte0[byte0 + offset] = (byte)(word0 >>> (1 - byte0) * 8);
            byte0 = (byte)(byte0 + 1);
        }
    }

    public static final byte[] toByte(long l) {
        byte[] abyte0 = new byte[8];
        int byte0 = 0;
        while (byte0 <= 7) {
            abyte0[byte0] = (byte)(l >>> (7 - byte0) * 8);
            byte0 = (byte)(byte0 + 1);
        }
        return abyte0;
    }

    public static final void toByte(long l, byte[] abyte0, int offset) {
        int byte0 = 0;
        while (byte0 <= 7) {
            abyte0[byte0 + offset] = (byte)(l >>> (7 - byte0) * 8);
            byte0 = (byte)(byte0 + 1);
        }
    }

    public static final byte[] toByte(char c) {
        byte[] abyte0 = new byte[2];
        int byte0 = 0;
        while (byte0 <= 1) {
            abyte0[byte0] = (byte)(c >>> (1 - byte0) * 8);
            byte0 = (byte)(byte0 + 1);
        }
        return abyte0;
    }

    public static final void toByte(char c, byte[] abyte0, int offset) {
        int byte0 = 0;
        while (byte0 <= 1) {
            abyte0[byte0 + offset] = (byte)(c >>> (1 - byte0) * 8);
            byte0 = (byte)(byte0 + 1);
        }
    }

    public static final byte[] toByte(float f2) {
        byte[] abyte0 = new byte[4];
        int i = Float.floatToIntBits(f2);
        abyte0 = ByteArrayConvert.toByte(i);
        return abyte0;
    }

    public static final void toByte(float f2, byte[] abyte0, int offset) {
        int i = Float.floatToIntBits(f2);
        ByteArrayConvert.toByte(i, abyte0, offset);
    }

    public static final byte[] toByte(double d) {
        byte[] abyte0 = new byte[8];
        long l = Double.doubleToLongBits(d);
        abyte0 = ByteArrayConvert.toByte(l);
        return abyte0;
    }

    public static final void toByte(double d, byte[] abyte0, int offset) {
        long l = Double.doubleToLongBits(d);
        ByteArrayConvert.toByte(l, abyte0, offset);
    }

    public static final int toInt(byte[] abyte0, int offset) {
        int i = 0;
        int byte0 = offset;
        while (byte0 <= offset + 3) {
            int j;
            if (abyte0[byte0] < 0) {
                abyte0[byte0] = (byte)(abyte0[byte0] & 0x7F);
                j = abyte0[byte0];
                j |= 0x80;
            } else {
                j = abyte0[byte0];
            }
            i |= j;
            if (byte0 < 3 + offset) {
                i <<= 8;
            }
            ++byte0;
        }
        return i;
    }

    public static final int toInt(byte[] abyte0) {
        return ByteArrayConvert.toInt(abyte0, 0);
    }

    public static final short toShort(byte[] abyte0, int offset) {
        short word0 = 0;
        int byte0 = offset;
        while (byte0 <= offset + 1) {
            short word1;
            if (abyte0[byte0] < 0) {
                abyte0[byte0] = (byte)(abyte0[byte0] & 0x7F);
                word1 = abyte0[byte0];
                word1 = (short)(word1 | 0x80);
            } else {
                word1 = abyte0[byte0];
            }
            word0 = (short)(word0 | word1);
            if (byte0 < 1 + offset) {
                word0 = (short)(word0 << 8);
            }
            ++byte0;
        }
        return word0;
    }

    public static final short toShort(byte[] abyte0) {
        return ByteArrayConvert.toShort(abyte0, 0);
    }

    public static final long toLong(byte[] abyte0, int offset) {
        long l = 0L;
        int byte0 = offset;
        while (byte0 <= offset + 7) {
            long l1;
            if (abyte0[byte0] < 0) {
                abyte0[byte0] = (byte)(abyte0[byte0] & 0x7F);
                l1 = abyte0[byte0];
                l1 |= 0x80L;
            } else {
                l1 = abyte0[byte0];
            }
            l |= l1;
            if (byte0 < 7 + offset) {
                l <<= 8;
            }
            ++byte0;
        }
        return l;
    }

    public static final long toLong(byte[] abyte0) {
        return ByteArrayConvert.toLong(abyte0, 0);
    }

    public static final char toChar(byte[] abyte0, int offset) {
        char c = '\u0000';
        c = (char)((c | (char)abyte0[offset]) << 8);
        c = (char)(c | (char)abyte0[offset + 1]);
        return c;
    }

    public static final char toChar(byte[] abyte0) {
        return ByteArrayConvert.toChar(abyte0, 0);
    }

    public static final float toFloat(byte[] abyte0, int offset) {
        float f2 = 0.0f;
        int i = ByteArrayConvert.toInt(abyte0, offset);
        f2 = Float.intBitsToFloat(i);
        return f2;
    }

    public static final float toFloat(byte[] abyte0) {
        return ByteArrayConvert.toFloat(abyte0, 0);
    }

    public static final double toDouble(byte[] abyte0, int offset) {
        double d = 0.0;
        long l = ByteArrayConvert.toLong(abyte0, offset);
        d = Double.longBitsToDouble(l);
        return d;
    }

    public static final double toDouble(byte[] abyte0) {
        return ByteArrayConvert.toDouble(abyte0, 0);
    }

    public static String toHexString(byte[] data2, int offset, int len) {
        StringBuffer sb = new StringBuffer(len * 2);
        int i = offset;
        while (i < len) {
            sb.append(Integer.toHexString(data2[i] & 0xFF));
            ++i;
        }
        return sb.toString();
    }
}

