/*
 * Decompiled with CFR 0.152.
 */
package dragon.onlinedb.trec;

import dragon.onlinedb.Article;
import dragon.onlinedb.ArticleParser;
import dragon.onlinedb.CollectionReader;
import dragon.util.FileUtil;
import java.io.BufferedReader;
import java.io.File;

public class TrecFileReader
implements CollectionReader {
    private ArticleParser parser;
    private BufferedReader reader;
    private StringBuffer sb;
    private char[] buf;
    private String filename;
    private File colFile;
    private long curArticleOffset;
    private long deletedBytes;
    private int curArticleLength;
    private boolean done;

    public TrecFileReader(ArticleParser parser) {
        this(null, parser);
    }

    public TrecFileReader(File colFile, ArticleParser parser) {
        this.parser = parser;
        this.buf = new char[10240];
        this.loadCollection(colFile);
    }

    public boolean loadFile(String colFile) {
        return this.loadCollection(new File(colFile));
    }

    public boolean loadCollection(File colFile) {
        try {
            this.deletedBytes = 0L;
            this.curArticleOffset = -1L;
            this.curArticleLength = 0;
            this.colFile = colFile;
            if (colFile == null || !this.testCollectionFile(colFile)) {
                this.done = true;
                this.reader = null;
                this.sb = null;
                this.filename = null;
                return false;
            }
            this.filename = colFile.getName();
            this.reader = FileUtil.getTextReader(colFile);
            this.done = false;
            this.sb = new StringBuffer(10240);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.reader = null;
            this.done = true;
            return false;
        }
    }

    public ArticleParser getArticleParser() {
        return this.parser;
    }

    public void setArticleParser(ArticleParser parser) {
        this.parser = parser;
    }

    public Article getArticleByKey(String key) {
        return null;
    }

    public Article getNextArticle() {
        try {
            int start;
            if (this.reader == null || this.sb == null) {
                return null;
            }
            int end = this.sb.indexOf("</DOC>");
            while (end < 0 && !this.done) {
                int len = this.reader.read(this.buf);
                if (len < this.buf.length) {
                    this.done = true;
                }
                start = this.sb.length();
                this.sb.append(this.buf, 0, len);
                end = this.sb.indexOf("</DOC>", start);
            }
            if (end < 0) {
                return null;
            }
            start = this.sb.lastIndexOf("<DOC>", end += 6);
            if (start < 0) {
                return null;
            }
            this.curArticleOffset = this.deletedBytes + (long)start;
            this.curArticleLength = end - start;
            Article article = this.parser.parse(this.sb.substring(start, end));
            this.sb.delete(0, end);
            this.deletedBytes += (long)end;
            return article;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public long getArticleOffset() {
        return this.curArticleOffset;
    }

    public int getArticleLength() {
        return this.curArticleLength;
    }

    public String getArticleFilename() {
        return this.filename;
    }

    public void close() {
        try {
            if (this.reader != null) {
                this.reader.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private boolean testCollectionFile(File file) {
        try {
            if (!file.exists() || file.isDirectory()) {
                return false;
            }
            BufferedReader br = FileUtil.getTextReader(file);
            boolean ret = br.readLine().trim().equalsIgnoreCase("<DOC>");
            br.close();
            return ret;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean supportArticleKeyRetrieval() {
        return false;
    }

    public void restart() {
        this.loadCollection(this.colFile);
    }
}

