/*
 * Decompiled with CFR 0.152.
 */
package dragon.onlinedb.pubmed;

import dragon.onlinedb.AbstractQuery;
import dragon.onlinedb.Article;
import dragon.onlinedb.pubmed.PubMedArticle;
import dragon.util.HttpUtil;

public class PubMedQuery
extends AbstractQuery {
    protected HttpUtil http;
    protected String webEnv;
    protected String queryKey;
    protected String database;
    protected String term;
    protected String eSearchUrl;
    protected String eFetchUrl;
    protected String server;
    protected String startDate;
    protected String endDate;
    protected String[] arrPaper;

    public static void main(String[] args) {
        PubMedQuery query = new PubMedQuery(1);
        String term = "hypertension[TIAB] AND diabetes[TIAB]";
        term = "";
        query.setSearchTerm(term);
        query.setDateRange("1995/01/01", "2003/12/31");
        query.initQuery();
        int top = 100000;
        int i = 0;
        while (i < top && query.moveToNextArticle()) {
            System.out.println(query.getArticle().getKey());
            ++i;
        }
    }

    public PubMedQuery(String term, int pageWidth) {
        super(pageWidth);
        this.arrPaper = new String[pageWidth];
        if (term != null) {
            this.term = term.replace(' ', '+');
        }
        this.eSearchUrl = "/entrez/eutils/esearch.fcgi?";
        this.eFetchUrl = "/entrez/eutils/efetch.fcgi?";
        this.server = "eutils.ncbi.nlm.nih.gov";
        this.http = new HttpUtil(this.server);
        this.startDate = null;
        this.endDate = null;
    }

    public PubMedQuery(int pageWidth) {
        this(null, pageWidth);
    }

    public boolean supportArticleKeyRetrieval() {
        return true;
    }

    public void setSearchTerm(String term) {
        this.term = term.replace(' ', '+');
    }

    public void setDateRange(String start, String end) {
        this.startDate = start;
        this.endDate = end;
    }

    public boolean initQuery() {
        String content;
        this.curPageNo = -1;
        this.curArticle = null;
        this.curPageWidth = 0;
        String curUrl = this.eSearchUrl + "usehistory=y&db=pubmed&term=" + this.term + "&retmax=1";
        if (this.startDate != null && this.endDate != null) {
            curUrl = curUrl + "&mindate=" + this.startDate + "&maxdate=" + this.endDate;
        }
        if ((content = this.http.get(curUrl)) == null) {
            return false;
        }
        int start = content.indexOf("<Count>") + 7;
        int end = content.indexOf("</Count>", start);
        this.articleNum = Integer.parseInt(content.substring(start, end));
        start = content.indexOf("<QueryKey>", start) + 10;
        end = content.indexOf("</QueryKey>", start);
        this.queryKey = content.substring(start, end);
        start = content.indexOf("<WebEnv>", start) + 8;
        end = content.indexOf("</WebEnv>", start);
        this.webEnv = content.substring(start, end);
        this.pageNum = this.articleNum == 0 ? 0 : (this.articleNum - 1) / this.pageWidth + 1;
        return true;
    }

    public boolean moveToPage(int pageNo) {
        if (pageNo >= this.pageNum || this.pageNum == 0) {
            return false;
        }
        if (pageNo == this.curPageNo) {
            return true;
        }
        String curUrl = this.eFetchUrl + "db=PubMed&WebEnv=" + this.webEnv + "&retmode=text&query_key=" + this.queryKey;
        String content = this.http.get(curUrl = curUrl + "&retmax=" + this.pageWidth + "&retstart=" + pageNo * this.pageWidth);
        if (content == null) {
            return false;
        }
        int count2 = 0;
        int start = content.indexOf("Pubmed-entry");
        while (start >= 0) {
            int end = content.indexOf("Pubmed-entry", start + 12);
            this.arrPaper[count2] = end >= 0 ? content.substring(start, end) : content.substring(start);
            ++count2;
            start = end;
        }
        this.curPageNo = pageNo;
        this.curPageWidth = count2;
        this.curArticleNo = 0;
        if (this.arrPaper[this.curArticleNo] == null) {
            return false;
        }
        this.curArticle = new PubMedArticle(this.arrPaper[this.curArticleNo]);
        return true;
    }

    public Article getArticleByKey(String PMID) {
        String curUrl = this.eFetchUrl + "db=PubMed&retmode=text&id=" + PMID;
        String content = this.http.get(curUrl);
        if (content == null) {
            return null;
        }
        int start = content.indexOf("Pubmed-entry");
        if (start >= 0) {
            return new PubMedArticle(content);
        }
        return null;
    }

    protected Article getArticle(int articleNo) {
        return new PubMedArticle(this.arrPaper[articleNo]);
    }
}

