/*
 * Decompiled with CFR 0.152.
 */
package dragon.onlinedb.pubmed;

import dragon.onlinedb.BasicArticle;

public class PubMedArticle
extends BasicArticle {
    private String[] arrMeSH = null;

    public PubMedArticle() {
    }

    public PubMedArticle(String rawText) {
        this.parseDef(rawText);
    }

    private boolean parseDef(String content) {
        int start = content.indexOf("pmid") + 4;
        int end = content.indexOf(",", start);
        this.key = content.substring(start, end).trim();
        start = end;
        start = content.indexOf("title {");
        if (start >= 0) {
            start = content.indexOf(34, start) + 1;
            end = content.indexOf("\"\n", start);
            this.title = content.substring(start, end).replace('\n', ' ');
        }
        start = end;
        start = content.indexOf("abstract \"");
        if (start >= 0) {
            end = content.indexOf("\",\n    ", start += 10);
            this.abt = content.substring(start, end);
        }
        start = end;
        start = content.indexOf("mesh {");
        if (start >= 0) {
            end = content.indexOf("\n    },", start += 6);
            String mesh = content.substring(start, end);
            start = mesh.indexOf("term \"");
            while (start >= 0) {
                end = mesh.indexOf("\"", start += 6);
                this.meta = this.meta == null ? mesh.substring(start, end) : this.meta + "," + mesh.substring(start, end);
                start = mesh.indexOf("term \"", end);
            }
            if (this.meta != null) {
                this.arrMeSH = this.meta.split(",");
            }
        }
        return true;
    }

    public int getMeSHNum() {
        if (this.arrMeSH == null) {
            return 0;
        }
        return this.arrMeSH.length;
    }

    public String getMainHeading(int index) {
        return this.arrMeSH[index].toString();
    }
}

