/*
 * Decompiled with CFR 0.152.
 */
package dragon.onlinedb;

import dragon.onlinedb.Article;
import dragon.onlinedb.ArticleParser;
import dragon.onlinedb.BasicArticleIndex;
import dragon.onlinedb.BasicArticleKey;
import dragon.onlinedb.BasicArticleParser;
import dragon.onlinedb.CollectionReader;
import dragon.util.FileUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.RandomAccessFile;

public class BasicCollectionReader
implements CollectionReader {
    protected ArticleParser parser;
    protected BufferedReader br;
    protected BasicArticleIndex indexList;
    protected RandomAccessFile raf;
    protected String collectionFile;
    protected String indexFile;

    public BasicCollectionReader() {
        this.parser = new BasicArticleParser();
        this.br = null;
    }

    public BasicCollectionReader(String collectionFile) {
        this(collectionFile, null);
    }

    public BasicCollectionReader(String collectionFile, String indexFile) {
        this.parser = new BasicArticleParser();
        this.loadCollection(collectionFile, indexFile);
    }

    public BasicCollectionReader(String collectionFile, String indexFile, ArticleParser parser) {
        this.parser = parser;
        this.loadCollection(collectionFile, indexFile);
    }

    public boolean loadCollection(String collectionFile, String indexFile) {
        try {
            this.close();
            this.br = FileUtil.getTextReader(collectionFile);
            if (indexFile != null && new File(indexFile).exists()) {
                this.indexList = new BasicArticleIndex(indexFile, false);
            } else {
                indexFile = null;
            }
            this.raf = new RandomAccessFile(collectionFile, "r");
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public ArticleParser getArticleParser() {
        return this.parser;
    }

    public void setArticleParser(ArticleParser parser) {
        this.parser = parser;
    }

    public Article getArticleByKey(String key) {
        try {
            BasicArticleKey curKey = this.indexList.search(key);
            if (curKey == null) {
                return null;
            }
            this.raf.seek(curKey.getOffset());
            String line = this.raf.readLine();
            return this.parser.parse(line);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public Article getNextArticle() {
        try {
            if (this.parser == null || this.br == null) {
                return null;
            }
            String line = this.br.readLine();
            if (line == null || line.trim().length() == 0) {
                return null;
            }
            return this.parser.parse(line);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public void close() {
        try {
            if (this.indexList != null) {
                this.indexList.close();
            }
            if (this.br != null) {
                this.br.close();
            }
            if (this.raf != null) {
                this.raf.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean supportArticleKeyRetrieval() {
        return this.indexList != null;
    }

    public void restart() {
        this.loadCollection(this.collectionFile, this.indexFile);
    }
}

