/*
 * Decompiled with CFR 0.152.
 */
package dragon.onlinedb;

import dragon.onlinedb.Article;
import dragon.onlinedb.ArticleParser;
import dragon.onlinedb.ArticleQuery;

public abstract class AbstractQuery
implements ArticleQuery {
    protected int curPageNo;
    protected int curArticleNo;
    protected int pageNum;
    protected int articleNum;
    protected int pageWidth;
    protected int curPageWidth;
    protected Article curArticle;
    protected ArticleParser parser;

    protected abstract Article getArticle(int var1);

    public AbstractQuery(int pageWidth) {
        this.pageWidth = pageWidth;
        this.curPageNo = -1;
        this.curArticle = null;
    }

    public int getCurPageNo() {
        return this.curPageNo;
    }

    public boolean moveToNextPage() {
        return this.moveToPage(this.curPageNo + 1);
    }

    public int getTotalArticleNum() {
        return this.articleNum;
    }

    public int getPageNum() {
        return this.pageNum;
    }

    public int getPageWidth() {
        return this.pageWidth;
    }

    public int getCurPageWidth() {
        return this.curPageWidth;
    }

    public boolean moveToNextArticle() {
        if (this.curArticleNo >= this.curPageWidth - 1 || this.curPageNo < 0) {
            if (!this.moveToNextPage()) {
                return false;
            }
        } else {
            ++this.curArticleNo;
            this.curArticle = this.getArticle(this.curArticleNo);
        }
        return true;
    }

    public boolean moveToArticle(int paperNo) {
        if (paperNo < 0 || paperNo > this.curPageWidth) {
            return false;
        }
        this.curArticleNo = paperNo;
        this.curArticle = this.getArticle(this.curArticleNo);
        return true;
    }

    public Article getArticle() {
        return this.curArticle;
    }

    public String getArticleKey() {
        return this.curArticle.getKey();
    }

    public boolean loadCollection(String collectionPath, String collectionName) {
        return false;
    }

    public ArticleParser getArticleParser() {
        return this.parser;
    }

    public void setArticleParser(ArticleParser parser) {
        this.parser = parser;
    }

    public Article getNextArticle() {
        if (this.moveToNextArticle()) {
            return this.curArticle;
        }
        return null;
    }

    public void close() {
        this.curPageNo = -1;
        this.curArticle = null;
    }

    public void restart() {
        this.close();
        this.initQuery();
    }
}

