/*
 * Decompiled with CFR 0.152.
 */
package dragon.nlp.tool.xtract;

import dragon.nlp.SimpleElementList;
import dragon.nlp.Token;
import dragon.nlp.extract.EngDocumentParser;
import dragon.nlp.tool.Lemmatiser;
import dragon.nlp.tool.Tagger;
import dragon.nlp.tool.xtract.EngWordPairExpand;
import dragon.nlp.tool.xtract.EngWordPairIndexer;
import dragon.nlp.tool.xtract.WordPairExpand;
import dragon.nlp.tool.xtract.WordPairFilter;
import dragon.nlp.tool.xtract.WordPairIndexer;
import dragon.nlp.tool.xtract.WordPairStat;
import dragon.onlinedb.CollectionReader;
import dragon.util.FileUtil;
import dragon.util.SortedArray;
import java.io.BufferedWriter;
import java.io.PrintWriter;
import java.util.ArrayList;

public class SimpleXtract {
    private int maxSpan;
    private String indexFolder;

    public SimpleXtract(int maxSpan, String workingDir) {
        this.maxSpan = maxSpan;
        this.indexFolder = workingDir;
    }

    public void index(CollectionReader cr, Tagger tagger, Lemmatiser lemmatiser) {
        this.index(cr, tagger, lemmatiser);
    }

    public void index(CollectionReader cr, Tagger tagger, Lemmatiser lemmatiser, String wordDelimitor) {
        CollectionReader[] arrReader = new CollectionReader[]{cr};
        this.index(arrReader, tagger, lemmatiser, wordDelimitor);
    }

    public void index(CollectionReader[] cr, Tagger tagger, Lemmatiser lemmatiser) {
        this.index(cr, tagger, lemmatiser, null);
    }

    public void index(CollectionReader[] cr, Tagger tagger, Lemmatiser lemmatiser, String wordDelimitor) {
        EngWordPairIndexer indexer = new EngWordPairIndexer(this.indexFolder, this.maxSpan, tagger, lemmatiser);
        if (wordDelimitor != null && wordDelimitor.length() > 0) {
            indexer.setDocumentParser(new EngDocumentParser(wordDelimitor));
        }
        int i = 0;
        while (i < cr.length) {
            indexer.index(cr[i]);
            ++i;
        }
        indexer.close();
    }

    public void index(CollectionReader cr, WordPairIndexer indexer) {
        CollectionReader[] arrReader = new CollectionReader[]{cr};
        this.index(arrReader, indexer);
    }

    public void index(CollectionReader[] cr, WordPairIndexer indexer) {
        int i = 0;
        while (i < cr.length) {
            indexer.index(cr[i]);
            ++i;
        }
        indexer.close();
    }

    public void extract(double minStrength, double minSpread, double minZScore, double minExpandRatio, String outputFile) {
        EngWordPairExpand expander = new EngWordPairExpand(this.maxSpan, this.indexFolder, minExpandRatio);
        this.extract(expander, minStrength, minSpread, minZScore, outputFile);
    }

    public void extract(WordPairExpand expander, double minStrength, double minSpread, double minZScore, String outputFile) {
        SortedArray phraseList = new SortedArray();
        PrintWriter screen = FileUtil.getScreen();
        WordPairStat[] arrStat = this.filter(minStrength, minSpread, minZScore);
        int i = 0;
        while (i < arrStat.length) {
            int j = 1;
            while (j < this.maxSpan) {
                if (arrStat[i].getFrequency(j) > 0) {
                    this.addPhrase(expander.expand(arrStat[i], j), phraseList, screen);
                }
                if (arrStat[i].getFrequency(-j) > 0) {
                    this.addPhrase(expander.expand(arrStat[i], -j), phraseList, screen);
                }
                ++j;
            }
            ++i;
        }
        this.printPhrase(phraseList, outputFile);
    }

    private void addPhrase(ArrayList inputList, SortedArray phraseList, PrintWriter screen) {
        if (inputList == null) {
            return;
        }
        int i = 0;
        while (i < inputList.size()) {
            Token token2 = (Token)inputList.get(i);
            if (!phraseList.add(token2)) {
                Token old = (Token)phraseList.get(phraseList.insertedPos());
                old.setFrequency(Math.max(old.getFrequency(), token2.getFrequency()));
            }
            screen.println(token2.getValue() + "  " + token2.getFrequency());
            ++i;
        }
    }

    private WordPairStat[] filter(double minStrength, double minSpread, double minZScore) {
        WordPairFilter pairFilter = new WordPairFilter(this.indexFolder, this.maxSpan, minStrength, minSpread, minZScore);
        WordPairStat[] arrStat = pairFilter.execute();
        return arrStat;
    }

    private void printPhrase(SortedArray list2, String filename) {
        try {
            BufferedWriter bw = FileUtil.getTextWriter(filename);
            bw.write(list2.size() + "\n");
            int i = 0;
            while (i < list2.size()) {
                Token token2 = (Token)list2.get(i);
                bw.write(token2.getValue());
                bw.write(9 + token2.getFrequency());
                bw.write(10);
                bw.flush();
                ++i;
            }
            bw.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void printWordPair(WordPairStat[] arrStat, String filename) {
        try {
            SimpleElementList wordkeyList = new SimpleElementList(this.indexFolder + "/wordkey.list", false);
            SortedArray pairList = new SortedArray();
            int i = 0;
            while (i < arrStat.length) {
                String pair2 = wordkeyList.search(arrStat[i].getFirstWord()) + " " + wordkeyList.search(arrStat[i].getSecondWord());
                pairList.add(pair2.toLowerCase());
                ++i;
            }
            this.printPhrase(pairList, filename);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

