/*
 * Decompiled with CFR 0.152.
 */
package dragon.nlp.tool.lemmatiser;

import dragon.nlp.tool.lemmatiser.Operation;
import dragon.util.SortedArray;

public class LemmatiserPOS {
    private Operation[] operations;
    private int pos;
    private SortedArray indexList;

    public LemmatiserPOS(int POS2, Operation[] operations) {
        this.operations = operations;
        this.pos = POS2;
        this.indexList = null;
    }

    public LemmatiserPOS(int POS2, Operation[] operations, SortedArray indexList) {
        this.operations = operations;
        this.pos = POS2;
        this.indexList = indexList;
    }

    public String lemmatise(String derivation) {
        boolean indexChecked = false;
        int i = 0;
        while (i < this.operations.length) {
            String base = this.operations[i].execute(derivation);
            if (base != null) {
                indexChecked = true;
                if (!this.operations[i].getIndexLookupOption() || this.indexList == null || this.indexList.contains(base)) {
                    return base;
                }
            }
            ++i;
        }
        if (indexChecked) {
            return null;
        }
        if (this.indexList != null && this.indexList.contains(derivation)) {
            return derivation;
        }
        return null;
    }

    public int getPOSIndex() {
        return this.pos;
    }

    public SortedArray getIndexList() {
        return this.indexList;
    }
}

