/*
 * Decompiled with CFR 0.152.
 */
package dragon.nlp.tool.lemmatiser;

import dragon.nlp.tool.Lemmatiser;
import dragon.nlp.tool.lemmatiser.ExceptionOperation;
import dragon.nlp.tool.lemmatiser.LemmatiserPOS;
import dragon.nlp.tool.lemmatiser.Operation;
import dragon.nlp.tool.lemmatiser.SuffixDetachOperation;
import dragon.nlp.tool.lemmatiser.SuffixEDetachOperation;
import dragon.nlp.tool.lemmatiser.VerbOperation;
import dragon.util.EnvVariable;
import dragon.util.FileUtil;
import dragon.util.SortedArray;
import java.io.BufferedReader;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;

public class EngLemmatiser
implements Lemmatiser {
    private LemmatiserPOS[] arrLemmatiser;
    private LemmatiserPOS[] arrOrderedLemmatiser;
    private String nounSuffix;
    private String verbSuffix;
    private String adjSuffix;
    private String advSuffix;
    private String nounSuffixE;
    private String verbSuffixE;
    private String adjSuffixE;
    private String advSuffixE;
    private String directory;
    private boolean indexLookupOption;
    private boolean disableVerbAdjective;

    public static void main(String[] args) {
        EngLemmatiser lemmatiser = new EngLemmatiser(false, true);
        System.out.println(lemmatiser.lemmatize("married", 1));
    }

    public EngLemmatiser() {
        this(EnvVariable.getDragonHome() + "/nlpdata/lemmatiser", false, true);
    }

    public EngLemmatiser(boolean indexLookupOption, boolean disableVerbAdjective) {
        this(EnvVariable.getDragonHome() + "/nlpdata/lemmatiser", indexLookupOption, disableVerbAdjective);
    }

    public EngLemmatiser(String directory, boolean indexLookupOption, boolean disableVerbAdjective) {
        this.initialize(directory, indexLookupOption, disableVerbAdjective);
    }

    private void initialize(String workDir, boolean indexLookupOption, boolean disableVerbAdjective) {
        if (!FileUtil.exist(workDir) && FileUtil.exist(EnvVariable.getDragonHome() + "/" + workDir)) {
            workDir = EnvVariable.getDragonHome() + "/" + workDir;
        }
        this.directory = workDir;
        this.indexLookupOption = indexLookupOption;
        this.disableVerbAdjective = disableVerbAdjective;
        this.nounSuffix = "ches=ch;shes=sh;ses=s;xes=x;zes=z;men=man;ies=y;s=";
        this.verbSuffix = "s=";
        this.adjSuffix = "";
        this.advSuffix = "";
        this.nounSuffixE = "";
        this.verbSuffixE = "ed;ing";
        this.adjSuffixE = "er;est";
        this.advSuffixE = "er;est";
        this.arrLemmatiser = new LemmatiserPOS[4];
        System.out.println(new Date() + " loading exception data for lemmatiser...");
        int i = 0;
        while (i < 4) {
            this.arrLemmatiser[i] = this.loadLemmatiser(i + 1);
            ++i;
        }
        this.arrOrderedLemmatiser = new LemmatiserPOS[4];
        this.arrOrderedLemmatiser[0] = this.arrLemmatiser[1];
        this.arrOrderedLemmatiser[1] = this.arrLemmatiser[2];
        this.arrOrderedLemmatiser[2] = this.arrLemmatiser[3];
        this.arrOrderedLemmatiser[3] = this.arrLemmatiser[0];
        System.out.println(new Date() + " loading done");
    }

    public String lemmatize(String derivation, int POS2) {
        derivation = derivation.toLowerCase();
        if (POS2 > 4 || POS2 < 1) {
            return derivation;
        }
        String base = this.arrLemmatiser[POS2 - 1].lemmatise(derivation);
        if (base == null) {
            return derivation;
        }
        return base;
    }

    public String lemmatize(String derivation) {
        derivation = derivation.toLowerCase();
        int i = 1;
        while (i <= 4) {
            String base = this.arrLemmatiser[i - 1].lemmatise(derivation);
            if (base != null) {
                return base;
            }
            ++i;
        }
        return derivation;
    }

    public String stem(String derivation) {
        return this.lemmatize(derivation);
    }

    private LemmatiserPOS loadLemmatiser(int POS2) {
        SortedArray indexlist;
        String suffixE;
        String suffix;
        String indexFile;
        String exceptionFile;
        switch (POS2) {
            case 1: {
                exceptionFile = this.directory + "/noun.exc";
                indexFile = this.directory + "/noun.index";
                suffix = this.nounSuffix;
                suffixE = this.nounSuffixE;
                break;
            }
            case 2: {
                exceptionFile = this.directory + "/verb.exc";
                indexFile = this.directory + "/verb.index";
                suffix = this.verbSuffix;
                suffixE = this.verbSuffixE;
                break;
            }
            case 3: {
                exceptionFile = this.directory + "/adj.exc";
                indexFile = this.directory + "/adj.index";
                suffix = this.adjSuffix;
                suffixE = this.adjSuffixE;
                break;
            }
            case 4: {
                exceptionFile = this.directory + "/adv.exc";
                indexFile = this.directory + "/adv.index";
                suffix = this.advSuffix;
                suffixE = this.advSuffixE;
                break;
            }
            default: {
                return null;
            }
        }
        ArrayList<Operation> list2 = new ArrayList<Operation>();
        list2.add(new ExceptionOperation(POS2, exceptionFile));
        if (POS2 == 2) {
            this.loadSuffixDetachOperations(POS2, "ies=y", list2);
            this.loadSuffixEDetachOperations(POS2, "es", list2);
        }
        this.loadSuffixDetachOperations(POS2, suffix, list2);
        this.loadSuffixEDetachOperations(POS2, suffixE, list2);
        if (POS2 == 3 && this.disableVerbAdjective) {
            indexlist = this.arrLemmatiser[1].getIndexList();
            if (indexlist == null) {
                indexlist = this.loadIndexList(this.directory + "/verb.index");
            }
            list2.add(new VerbOperation(indexlist));
        }
        Operation[] operations = new Operation[list2.size()];
        int i = 0;
        while (i < list2.size()) {
            operations[i] = (Operation)list2.get(i);
            ++i;
        }
        indexlist = this.indexLookupOption ? this.loadIndexList(indexFile) : null;
        return new LemmatiserPOS(POS2, operations, indexlist);
    }

    private void loadSuffixDetachOperations(int POS2, String suffix, ArrayList operations) {
        if (suffix == null || suffix.trim().length() == 0) {
            return;
        }
        String[] arrSuffix = suffix.split(";");
        int i = 0;
        while (i < arrSuffix.length) {
            int j = arrSuffix[i].indexOf(61);
            String master = arrSuffix[i].substring(0, j);
            String slave = j == arrSuffix[i].length() - 1 ? null : arrSuffix[i].substring(j + 1);
            SuffixDetachOperation curOperation = new SuffixDetachOperation(POS2, master, slave);
            curOperation.setIndexLookupOption(this.indexLookupOption);
            operations.add(curOperation);
            ++i;
        }
    }

    private void loadSuffixEDetachOperations(int POS2, String suffixE, ArrayList operations) {
        if (suffixE == null || suffixE.trim().length() == 0) {
            return;
        }
        String[] arrSuffixE = suffixE.split(";");
        int i = 0;
        while (i < arrSuffixE.length) {
            SuffixEDetachOperation curOperation = new SuffixEDetachOperation(POS2, arrSuffixE[i]);
            curOperation.setIndexLookupOption(this.indexLookupOption);
            operations.add(curOperation);
            ++i;
        }
    }

    private SortedArray loadIndexList(String filename) {
        try {
            File file = new File(filename);
            if (!file.exists()) {
                return null;
            }
            BufferedReader br = FileUtil.getTextReader(filename);
            String line = br.readLine();
            int total = Integer.parseInt(line);
            ArrayList<String> list2 = new ArrayList<String>(total);
            int i = 0;
            while (i < total) {
                line = br.readLine();
                list2.add(line);
                ++i;
            }
            br.close();
            SortedArray indexlist = new SortedArray();
            indexlist.addAll(list2);
            return indexlist;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

