/*
 * Decompiled with CFR 0.152.
 */
package dragon.nlp.tool;

import dragon.nlp.Sentence;
import dragon.nlp.Word;
import dragon.nlp.tool.AbstractTagger;
import dragon.nlp.tool.Tagger;
import dragon.util.EnvVariable;
import dragon.util.FileUtil;
import hepple.postag.POSTagger;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class HeppleTagger
extends AbstractTagger
implements Tagger {
    private POSTagger tag;

    public HeppleTagger() {
        this(EnvVariable.getDragonHome() + "/nlpdata/tagger");
    }

    public HeppleTagger(String workDir) {
        try {
            if (!FileUtil.exist(workDir) && FileUtil.exist(EnvVariable.getDragonHome() + "/" + workDir)) {
                workDir = EnvVariable.getDragonHome() + "/" + workDir;
            }
            this.tag = new POSTagger(new File(workDir + "/lexicon_all").toURL(), new File(workDir + "/rules_cap").toURL());
            if (this.tag == null) {
                System.out.println("Failed to create POS tagger");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void tag(Sentence sent) {
        ArrayList<String> sentenceForTagger = new ArrayList<String>();
        ArrayList<ArrayList<String>> sentencesForTagger = new ArrayList<ArrayList<String>>(1);
        sentencesForTagger.add(sentenceForTagger);
        Word word = sent.getFirstWord();
        while (word != null) {
            sentenceForTagger.add(word.getContent());
            word = word.next;
        }
        List result2 = this.tag.runTagger(sentencesForTagger);
        if (result2.size() <= 0) {
            return;
        }
        result2 = (List)result2.get(0);
        word = sent.getFirstWord();
        int i = 0;
        while (i < result2.size()) {
            String[] output2 = (String[])result2.get(i);
            word.setPOS(output2[1], this.getPOSIndex(output2[1], word));
            word = word.next;
            ++i;
        }
    }

    protected int getPOSIndex(String pos, Word word) {
        int posIndex;
        if (word.isPunctuation()) {
            pos = word.getContent();
            posIndex = 0;
        } else {
            posIndex = pos.startsWith("N") ? 1 : (pos.startsWith("VB") ? 2 : (pos.startsWith("JJ") ? 3 : (pos.startsWith("RB") ? 4 : (pos.startsWith("CC") ? 8 : (pos.startsWith("DT") ? 7 : (pos.startsWith("PRP") ? 6 : (pos.startsWith("IN") ? (this.isConjunction(word.getContent()) ? 8 : 5) : (pos.startsWith("TO") ? 5 : (pos.startsWith("CD") ? (word.isNumber() ? 9 : 1) : (pos.startsWith("W") ? 8 : 0))))))))));
        }
        if (posIndex > 0 && posIndex != 1 && word.isAllCapital()) {
            posIndex = 1;
        }
        return posIndex;
    }
}

