/*
 * Decompiled with CFR 0.152.
 */
package dragon.nlp.tool;

import dragon.nlp.Document;
import dragon.nlp.Paragraph;
import dragon.nlp.Sentence;
import dragon.nlp.Term;
import dragon.nlp.Token;
import dragon.nlp.tool.NER;
import dragon.util.EnvVariable;
import dragon.util.FileUtil;
import dragon.util.SortedArray;
import gate.Annotation;
import gate.AnnotationSet;
import gate.Corpus;
import gate.Factory;
import gate.FeatureMap;
import gate.Gate;
import gate.ProcessingResource;
import gate.corpora.DocumentImpl;
import gate.creole.ANNIEConstants;
import gate.creole.SerialAnalyserController;
import java.io.File;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class Annie
implements NER {
    private SerialAnalyserController annieController;
    private Corpus corpus;
    private Set annotTypesRequired;

    public Annie() throws Exception {
        this.initAnnie(EnvVariable.getDragonHome() + "/nlpdata/gate");
    }

    public Annie(String gateHome) throws Exception {
        if (!FileUtil.exist(gateHome) && FileUtil.exist(EnvVariable.getDragonHome() + "/" + gateHome)) {
            gateHome = EnvVariable.getDragonHome() + "/" + gateHome;
        }
        this.initAnnie(gateHome);
    }

    public void initAnnie(String gateHome) throws Exception {
        Gate.setGateHome((File)new File(gateHome));
        Gate.setPluginsHome((File)new File(gateHome));
        Gate.setUserConfigFile((File)new File(Gate.getGateHome(), "gate.xml"));
        Gate.init();
        Gate.getCreoleRegister().registerDirectories(new File(Gate.getGateHome(), "ANNIE").toURL());
        System.out.println("Initializing ANNIE...");
        this.annieController = (SerialAnalyserController)Factory.createResource((String)"gate.creole.SerialAnalyserController", (FeatureMap)Factory.newFeatureMap(), (FeatureMap)Factory.newFeatureMap(), (String)("ANNIE_" + Gate.genSym()));
        int i = 0;
        while (i < ANNIEConstants.PR_NAMES.length - 1) {
            FeatureMap params = Factory.newFeatureMap();
            ProcessingResource pr = (ProcessingResource)Factory.createResource((String)ANNIEConstants.PR_NAMES[i], (FeatureMap)params);
            this.annieController.add(pr);
            ++i;
        }
        System.out.println("...ANNIE loaded");
        this.corpus = (Corpus)Factory.createResource((String)"gate.corpora.CorpusImpl");
        this.annotTypesRequired = new HashSet();
        this.annotTypesRequired.add("Person");
        this.annotTypesRequired.add("Location");
        this.annotTypesRequired.add("Organization");
    }

    public void setAnnotationTypes(String[] arrType) {
        if (arrType == null || arrType.length == 0) {
            return;
        }
        this.annotTypesRequired = new HashSet();
        int i = 0;
        while (i < arrType.length) {
            this.annotTypesRequired.add(arrType[i]);
            ++i;
        }
    }

    public void close() {
        this.annieController.cleanup();
    }

    public ArrayList extractEntities(String content) {
        try {
            content = content.replaceAll("\r\n", " ");
            content = content.replace('\r', ' ');
            content = content.replace('\n', ' ');
            SortedArray entityList = new SortedArray();
            DocumentImpl doc = new DocumentImpl();
            doc.setStringContent(content);
            doc.init();
            this.corpus.clear();
            this.corpus.add((Object)doc);
            this.annieController.setCorpus(this.corpus);
            this.annieController.execute();
            AnnotationSet defaultAnnotSet = doc.getAnnotations();
            defaultAnnotSet = defaultAnnotSet.get(this.annotTypesRequired);
            if (defaultAnnotSet == null) {
                return null;
            }
            Iterator it = defaultAnnotSet.iterator();
            while (it.hasNext()) {
                Annotation curAnnotation = (Annotation)it.next();
                Token curToken = new Token(content.substring(curAnnotation.getStartNode().getOffset().intValue(), curAnnotation.getEndNode().getOffset().intValue()));
                if (entityList.add(curToken)) continue;
                curToken = (Token)entityList.get(entityList.insertedPos());
                curToken.addFrequency(1);
            }
            doc.cleanup();
            return entityList;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public ArrayList extractFromDoc(Document doc) {
        try {
            ArrayList termList = new ArrayList(60);
            Paragraph pg = doc.getFirstParagraph();
            while (pg != null) {
                Sentence sent = pg.getFirstSentence();
                while (sent != null) {
                    ArrayList curTermList = this.extractFromSentence(sent);
                    if (curTermList != null) {
                        termList.addAll(curTermList);
                        curTermList.clear();
                    }
                    sent = sent.next;
                }
                pg = pg.next;
            }
            return termList;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    /*
     * Unable to fully structure code
     */
    public ArrayList extractFromSentence(Sentence sent) {
        try {
            content = new StringBuffer();
            curWord = sent.getFirstWord();
            while (curWord != null) {
                if (content.length() > 0) {
                    content.append(' ');
                }
                curWord.setOffset(content.length());
                content.append(curWord.getContent());
                curWord = curWord.next;
            }
            if (content.toString().trim().length() <= 20) {
                return null;
            }
            doc = new DocumentImpl();
            doc.setStringContent(content.toString());
            doc.init();
            this.corpus.clear();
            this.corpus.add((Object)doc);
            this.annieController.setCorpus(this.corpus);
            this.annieController.execute();
            defaultAnnotSet = doc.getAnnotations();
            defaultAnnotSet = defaultAnnotSet.get(this.annotTypesRequired);
            if (defaultAnnotSet == null) {
                return null;
            }
            annotationList = new SortedArray(new AnnotationComparator());
            it = defaultAnnotSet.iterator();
            if (it != null) ** GOTO lbl34
            return null;
lbl-1000:
            // 1 sources

            {
                annotationList.add((Object)it.next());
lbl34:
                // 2 sources

                ** while (it.hasNext())
            }
lbl35:
            // 1 sources

            termList = new ArrayList<Term>(annotationList.size());
            curWord = sent.getFirstWord();
            i = 0;
            while (i < annotationList.size()) {
                annot = (Annotation)annotationList.get(i);
                start = annot.getStartNode().getOffset().intValue();
                end = annot.getEndNode().getOffset().intValue();
                while (curWord.getOffset() < start) {
                    curWord = curWord.next;
                }
                if (curWord.getOffset() == start) {
                    startWord = curWord;
                    endWord = curWord;
                    curWord = curWord.next;
                    while (curWord != null && curWord.getOffset() < end) {
                        endWord = curWord;
                        curWord = curWord.next;
                    }
                    curTerm = new Term(startWord, endWord);
                    curTerm.setTUI(annot.getType());
                    termList.add(curTerm);
                    if (startWord.getAssociatedConcept() != null) {
                        startWord.setAssociatedConcept(curTerm);
                    }
                    curWord = startWord;
                }
                ++i;
            }
            return termList;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public String annotate(String original) {
        try {
            DocumentImpl doc = new DocumentImpl();
            doc.setStringContent(original);
            doc.init();
            this.corpus.clear();
            this.corpus.add((Object)doc);
            this.annieController.setCorpus(this.corpus);
            this.annieController.execute();
            AnnotationSet defaultAnnotSet = doc.getAnnotations();
            defaultAnnotSet = defaultAnnotSet.get(this.annotTypesRequired);
            return "<?xml version=\"1.0\" encoding=\"windows-1252\"?>\n<doc>" + doc.toXml((Set)defaultAnnotSet, false) + "</doc>";
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private class AnnotationComparator
    implements Comparator {
        private AnnotationComparator() {
        }

        public int compare(Object firstObj, Object secondObj) {
            long start2;
            long start1 = ((Annotation)firstObj).getStartNode().getOffset();
            if (start1 < (start2 = ((Annotation)secondObj).getStartNode().getOffset().longValue())) {
                return -1;
            }
            if (start1 == start2) {
                long end2;
                long end1 = ((Annotation)firstObj).getEndNode().getOffset();
                if (end1 > (end2 = ((Annotation)secondObj).getEndNode().getOffset().longValue())) {
                    return -1;
                }
                if (end1 < end2) {
                    return 1;
                }
                return 0;
            }
            return 1;
        }
    }
}

