/*
 * Decompiled with CFR 0.152.
 */
package dragon.nlp.ontology.umls;

import dragon.nlp.Token;
import dragon.util.FileUtil;
import dragon.util.SortedArray;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;

public class UmlsTokenList
extends SortedArray {
    private static final long serialVersionUID = 1L;

    public UmlsTokenList() {
    }

    public UmlsTokenList(String tokenFile) {
        this.loadTokenList(tokenFile);
    }

    public int addToken(Token token2) {
        token2.setIndex(this.size());
        if (this.add(token2)) {
            token2.setFrequency(1);
            return token2.getIndex();
        }
        token2 = (Token)this.get(this.insertedPos());
        token2.addFrequency(1);
        return token2.getIndex();
    }

    public Token tokenAt(int index) {
        return (Token)this.get(index);
    }

    public Token lookup(String token2) {
        int pos = this.binarySearch(new Token(token2));
        if (pos < 0) {
            return null;
        }
        return (Token)this.get(pos);
    }

    public Token lookup(Token token2) {
        int pos = this.binarySearch(token2);
        if (pos < 0) {
            return null;
        }
        return (Token)this.get(pos);
    }

    private void loadTokenList(String tokenFilename) {
        try {
            System.out.println(new Date() + " Loading Token List...");
            BufferedReader br = FileUtil.getTextReader(tokenFilename);
            String line = br.readLine();
            int len = Integer.parseInt(line);
            ArrayList<Token> tokenList = new ArrayList<Token>(len);
            int i = 0;
            while (i < len) {
                line = br.readLine();
                String[] strArr = line.split("\t");
                Token token2 = new Token(strArr[1]);
                token2.setIndex(Integer.parseInt(strArr[0]));
                int freq = Integer.parseInt(strArr[2]);
                token2.setFrequency(freq);
                token2.setWeight(1.0 / (double)freq);
                tokenList.add(token2);
                ++i;
            }
            br.close();
            Collections.sort(tokenList);
            this.addAll(tokenList);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void saveTo(String filename) {
        try {
            System.out.println(new Date() + " Saving Token List...");
            BufferedWriter bw = FileUtil.getTextWriter(filename);
            bw.write(this.size() + "");
            bw.write("\n");
            int i = 0;
            while (i < this.size()) {
                Token t = (Token)this.get(i);
                bw.write(t.getIndex() + "\t" + t.getValue() + "\t" + t.getFrequency() + "\n");
                bw.flush();
                ++i;
            }
            bw.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

