/*
 * Decompiled with CFR 0.152.
 */
package dragon.nlp.ontology.umls;

import dragon.nlp.Sentence;
import dragon.nlp.Term;
import dragon.nlp.Word;
import dragon.nlp.ontology.umls.UmlsOntology;
import dragon.nlp.tool.Lemmatiser;
import dragon.util.SortedArray;
import java.util.ArrayList;
import java.util.Collections;

public abstract class UmlsExactOntology
extends UmlsOntology {
    public UmlsExactOntology(Lemmatiser lemmatiser) {
        super(lemmatiser);
    }

    public String[] getSemanticType(String[] cuis) {
        String[] arrTypes;
        SortedArray typeList = new SortedArray(3);
        int i = 0;
        while (i < cuis.length) {
            arrTypes = this.getSemanticType(cuis[i]);
            if (arrTypes != null) {
                int j = 0;
                while (j < arrTypes.length) {
                    typeList.add(arrTypes[j]);
                    ++j;
                }
            }
            ++i;
        }
        if (typeList.size() > 0) {
            arrTypes = new String[typeList.size()];
            i = 0;
            while (i < typeList.size()) {
                arrTypes[i] = (String)typeList.get(i);
                ++i;
            }
            return arrTypes;
        }
        return null;
    }

    public abstract String[] getSemanticType(String var1);

    public abstract String[] getCUI(String var1);

    public String[] getCUI(Word starting, Word ending) {
        return this.getCUI(this.buildNormalizedTerm(starting, ending));
    }

    public abstract boolean isTerm(String var1);

    public boolean isTerm(Word starting, Word ending) {
        return this.isTerm(this.buildNormalizedTerm(starting, ending));
    }

    public ArrayList findAllTerms(Word start) {
        return this.findAllTerms(start, null);
    }

    public ArrayList findAllTerms(Word start, Word end) {
        return null;
    }

    public Term findTerm(Word start) {
        return this.findTerm(start, null);
    }

    public Term findTerm(Word start, Word end) {
        Sentence sent = start.getParent();
        Word curWord = start.next;
        if (end == null) {
            int j = 0;
            while (j < 4 && curWord != null && end == null) {
                if (this.isBoundaryWord(curWord)) {
                    end = curWord.prev;
                }
                if (!curWord.isPunctuation()) {
                    ++j;
                }
                curWord = curWord.next;
            }
            if (curWord == null) {
                curWord = sent.getLastWord();
            }
            if (end == null) {
                end = curWord;
            }
        }
        curWord = end;
        String[] arrCandidateCUI = null;
        while (curWord != null && curWord.getPosInSentence() >= start.getPosInSentence()) {
            int posIndex = curWord.getPOSIndex();
            if ((posIndex == 1 || posIndex == 9 && curWord.getPosInSentence() > start.getPosInSentence()) && (arrCandidateCUI = this.getCUI(start, curWord)) != null) break;
            curWord = curWord.prev;
        }
        if (arrCandidateCUI == null) {
            return null;
        }
        Term curTerm = new Term(start, end);
        start.setAssociatedConcept(curTerm);
        curTerm.setCandidateCUI(arrCandidateCUI);
        if (arrCandidateCUI.length == 1) {
            curTerm.setCUI(arrCandidateCUI[0]);
        }
        if (curTerm.getCUI() == null) {
            curTerm.setCandidateTUI(this.getSemanticType(curTerm.getCandidateCUI()));
        } else {
            curTerm.setCandidateTUI(this.getSemanticType(curTerm.getCUI()));
        }
        if (curTerm.getCandidateTUINum() == 1) {
            curTerm.setTUI(curTerm.getCandidateTUI(0));
        }
        return curTerm;
    }

    public String buildNormalizedTerm(Word start, Word end) {
        if (start.equals(end)) {
            return this.getLemma(start);
        }
        ArrayList<String> list2 = new ArrayList<String>(6);
        Word next2 = start;
        while (next2 != null) {
            if (this.isUsefulForTerm(next2)) {
                list2.add(this.getLemma(next2));
            }
            if (next2.equals(end)) break;
            next2 = next2.next;
        }
        Collections.sort(list2);
        StringBuffer term = new StringBuffer((String)list2.get(0));
        int i = 1;
        while (i < list2.size()) {
            term.append(' ');
            term.append((String)list2.get(i));
            ++i;
        }
        return term.toString();
    }
}

