/*
 * Decompiled with CFR 0.152.
 */
package dragon.nlp.ontology.umls;

import dragon.nlp.ontology.Ontology;
import dragon.nlp.ontology.SemanticNet;
import dragon.nlp.ontology.umls.UmlsExactOntology;
import dragon.nlp.ontology.umls.UmlsRelationNet;
import dragon.nlp.ontology.umls.UmlsSTYList;
import dragon.nlp.ontology.umls.UmlsSemanticNet;
import dragon.nlp.tool.Lemmatiser;
import dragon.util.DBUtil;
import java.sql.Connection;
import java.sql.ResultSet;

public class UmlsDBOntology
extends UmlsExactOntology
implements Ontology {
    private Connection con;
    private UmlsSemanticNet snNet;

    public UmlsDBOntology(Connection con, Lemmatiser lemmatiser) {
        super(lemmatiser);
        this.con = con;
        UmlsSTYList styList = new UmlsSTYList(con);
        UmlsRelationNet relationNet = new UmlsRelationNet(con, styList);
        this.snNet = new UmlsSemanticNet(this, styList, relationNet);
    }

    public Connection getConnection() {
        return this.con;
    }

    public void closeConnection() {
        try {
            if (this.con != null) {
                this.con.close();
                this.con = null;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public SemanticNet getSemanticNet() {
        return this.snNet;
    }

    public String[] getSemanticType(String[] cuis) {
        if (cuis == null) {
            return null;
        }
        StringBuffer sSQL = new StringBuffer("select distinct tui from mrsty where cui in (");
        int i = 0;
        while (i < cuis.length) {
            sSQL.append('\'');
            sSQL.append(cuis[i]);
            sSQL.append('\'');
            if (i < cuis.length - 1) {
                sSQL.append(',');
            } else {
                sSQL.append(')');
            }
            ++i;
        }
        return this.readSemanticTypes(sSQL.toString());
    }

    public String[] getSemanticType(String cui) {
        String sSQL = "select distinct tui from mrsty where cui='" + cui + "'";
        return this.readSemanticTypes(sSQL);
    }

    private String[] readSemanticTypes(String sql) {
        try {
            String[] arrTUI;
            ResultSet rs = DBUtil.getResultSet(this.con, sql);
            int count2 = DBUtil.getRecordCount(rs);
            if (count2 == 0) {
                arrTUI = null;
            } else {
                arrTUI = new String[count2];
                int i = 0;
                while (i < count2) {
                    arrTUI[i] = rs.getString("tui");
                    rs.next();
                    ++i;
                }
            }
            rs.close();
            rs.getStatement().close();
            return arrTUI;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public String[] getCUI(String term) {
        String sSQL = "select distinct cui from mrxns_eng where NSTR='" + term + "'";
        try {
            String[] arrCUI;
            ResultSet rs = DBUtil.getResultSet(this.con, sSQL);
            int count2 = DBUtil.getRecordCount(rs);
            if (count2 == 0) {
                arrCUI = null;
            } else {
                arrCUI = new String[count2];
                int i = 0;
                while (i < count2) {
                    arrCUI[i] = rs.getString("cui");
                    rs.next();
                    ++i;
                }
            }
            rs.close();
            rs.getStatement().close();
            return arrCUI;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public boolean isTerm(String term) {
        String sSQL = "select cui from mrxns_eng where NSTR='" + term + "' fetch first 1 rows only";
        try {
            ResultSet rs = DBUtil.getResultSet(this.con, sSQL);
            int count2 = DBUtil.getRecordCount(rs);
            rs.close();
            rs.getStatement().close();
            return count2 > 0;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }
}

