/*
 * Decompiled with CFR 0.152.
 */
package dragon.nlp.ontology.umls;

import dragon.nlp.compare.IndexComparator;
import dragon.nlp.ontology.umls.UmlsCUI;
import dragon.util.FileUtil;
import dragon.util.SortedArray;
import java.io.BufferedReader;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;

public class UmlsCUIList
extends SortedArray {
    private static final long serialVersionUID = 1L;

    public static void main(String[] args) {
        UmlsCUIList list2 = new UmlsCUIList("sir/cui.list");
        System.out.println(list2.lookup("C1153267").toString());
    }

    public UmlsCUIList() {
    }

    public UmlsCUIList(String cuiFile) {
        this.loadCUIList(cuiFile, false);
    }

    public UmlsCUIList(String cuiFile, boolean loadConceptName) {
        this.loadCUIList(cuiFile, loadConceptName);
    }

    public UmlsCUI cuiAt(int index) {
        return (UmlsCUI)this.get(index);
    }

    public ArrayList getListSortedByIndex() {
        ArrayList list2 = new ArrayList(this.size());
        int i = 0;
        while (i < this.size()) {
            list2.add(this.get(i));
            ++i;
        }
        Collections.sort(list2, new IndexComparator());
        return list2;
    }

    public boolean add(String cui, String[] stys) {
        UmlsCUI cur = new UmlsCUI(this.size(), cui, stys);
        return this.add(cur);
    }

    public UmlsCUI lookup(String cui) {
        int pos = this.binarySearch(new UmlsCUI(0, cui, null));
        if (pos < 0) {
            return null;
        }
        return (UmlsCUI)this.get(pos);
    }

    public UmlsCUI lookup(UmlsCUI cui) {
        int pos = this.binarySearch(cui);
        if (pos < 0) {
            return null;
        }
        return (UmlsCUI)this.get(pos);
    }

    public void saveTo(String filename) {
        try {
            System.out.println(new Date() + " Saving CUI List...");
            PrintWriter bw = FileUtil.getPrintWriter(filename);
            bw.write(this.size() + "\n");
            int i = 0;
            while (i < this.size()) {
                UmlsCUI cur = (UmlsCUI)this.get(i);
                bw.write(cur.getIndex() + "\t" + cur.toString() + "\t" + cur.getSTY(0));
                int j = 1;
                while (j < cur.getSTYNum()) {
                    bw.write("_" + cur.getSTY(j));
                    ++j;
                }
                if (cur.getName() != null && cur.getName().length() > 0) {
                    bw.write("\t" + cur.getName());
                }
                bw.write(10);
                bw.flush();
                ++i;
            }
            bw.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private boolean loadCUIList(String filename, boolean loadConceptName) {
        try {
            System.out.println(new Date() + " Loading CUI List...");
            BufferedReader br = FileUtil.getTextReader(filename);
            String line = br.readLine();
            int total = Integer.parseInt(line);
            ArrayList<UmlsCUI> list2 = new ArrayList<UmlsCUI>(total);
            String prevSTY = "";
            String[] prevArrSTY = null;
            int i = 0;
            while (i < total) {
                String[] arrSTY;
                line = br.readLine();
                String[] arrField = line.split("\t");
                if (prevSTY.equals(arrField[2])) {
                    arrSTY = prevArrSTY;
                } else {
                    arrSTY = arrField[2].split("_");
                    prevSTY = arrField[2];
                    prevArrSTY = arrSTY;
                }
                UmlsCUI cur = new UmlsCUI(Integer.parseInt(arrField[0]), arrField[1], arrSTY);
                if (arrField.length >= 4 && loadConceptName) {
                    cur.setName(arrField[3]);
                }
                list2.add(cur);
                ++i;
            }
            br.close();
            Collections.sort(list2);
            this.addAll(list2);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }
}

