/*
 * Decompiled with CFR 0.152.
 */
package dragon.nlp.ontology.umls;

import dragon.matrix.DoubleSuperSparseMatrix;
import dragon.matrix.SparseMatrix;
import dragon.nlp.Sentence;
import dragon.nlp.Term;
import dragon.nlp.Token;
import dragon.nlp.Word;
import dragon.nlp.ontology.Ontology;
import dragon.nlp.ontology.SemanticNet;
import dragon.nlp.ontology.umls.UmlsCUI;
import dragon.nlp.ontology.umls.UmlsCUIList;
import dragon.nlp.ontology.umls.UmlsOntology;
import dragon.nlp.ontology.umls.UmlsRelationNet;
import dragon.nlp.ontology.umls.UmlsSTYList;
import dragon.nlp.ontology.umls.UmlsSemanticNet;
import dragon.nlp.ontology.umls.UmlsTokenList;
import dragon.nlp.tool.Lemmatiser;
import dragon.util.EnvVariable;
import dragon.util.FileUtil;
import dragon.util.SortedArray;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;

public class UmlsAmbiguityOntology
extends UmlsOntology
implements Ontology {
    private double minScore;
    private double subtermMinScore;
    private int maxSkippedWords;
    private double minSelectivity;
    private SparseMatrix wtMatrix;
    private UmlsTokenList tokenList;
    private UmlsCUIList cuiList;
    private ArrayList cuiListByIndex;
    private File directory;
    private UmlsSemanticNet snNet;

    public UmlsAmbiguityOntology(Lemmatiser lemmatiser) {
        this(EnvVariable.getDragonHome() + "/nlpdata/umls", lemmatiser);
    }

    public UmlsAmbiguityOntology(String workDir, Lemmatiser lemmatiser) {
        super(lemmatiser);
        if (!FileUtil.exist(workDir) && FileUtil.exist(EnvVariable.getDragonHome() + "/" + workDir)) {
            workDir = EnvVariable.getDragonHome() + "/" + workDir;
        }
        this.directory = new File(workDir);
        System.out.println(new Date() + " Loading Token CUI Matrix...");
        this.wtMatrix = new DoubleSuperSparseMatrix(this.directory + "/index.list", this.directory + "/tokencui.matrix");
        this.tokenList = new UmlsTokenList(this.directory + "/token.list");
        this.cuiList = new UmlsCUIList(this.directory + "/cui.list");
        this.cuiListByIndex = this.cuiList.getListSortedByIndex();
        UmlsSTYList styList = new UmlsSTYList(this.directory + "/semantictype.list");
        UmlsRelationNet relationNet = new UmlsRelationNet(this.directory + "/semanticrelation.list", styList);
        this.snNet = new UmlsSemanticNet(this, styList, relationNet);
        System.out.println(new Date() + " Ontology Loading Done!");
        this.maxSkippedWords = 1;
        this.minScore = 0.95;
        this.subtermMinScore = 0.99;
        this.minSelectivity = 0.0;
    }

    public void setMinScore(double minScore) {
        this.minScore = minScore;
    }

    public double getMinScore() {
        return this.minScore;
    }

    public void setMinSelectivity(double minSelectivity) {
        this.minSelectivity = minSelectivity;
    }

    public double getMinSelectivity() {
        return this.minSelectivity;
    }

    public void setMaxSkippedWords(int num2) {
        this.maxSkippedWords = num2;
    }

    public int getMaxSkippedWords() {
        return this.maxSkippedWords;
    }

    public SemanticNet getSemanticNet() {
        return this.snNet;
    }

    public String[] getSemanticType(String[] cuis) {
        String[] arrTypes;
        SortedArray typeList = new SortedArray(3);
        int i = 0;
        while (i < cuis.length) {
            arrTypes = this.getSemanticType(cuis[i]);
            if (arrTypes != null) {
                int j = 0;
                while (j < arrTypes.length) {
                    typeList.add(arrTypes[j]);
                    ++j;
                }
            }
            ++i;
        }
        if (typeList.size() > 0) {
            arrTypes = new String[typeList.size()];
            i = 0;
            while (i < typeList.size()) {
                arrTypes[i] = (String)typeList.get(i);
                ++i;
            }
            return arrTypes;
        }
        return null;
    }

    public String[] getSemanticType(String cui) {
        UmlsCUI cur = this.cuiList.lookup(cui);
        if (cur == null) {
            return null;
        }
        return cur.getAllSTY();
    }

    public String[] getCUI(String term) {
        return null;
    }

    public String[] getCUI(Word starting, Word ending) {
        return null;
    }

    public boolean isTerm(String term) {
        return false;
    }

    public boolean isTerm(Word starting, Word ending) {
        return false;
    }

    public ArrayList findAllTerms(Word start) {
        return this.findAllTerms(start, null);
    }

    public ArrayList findAllTerms(Word start, Word end) {
        CandidateTerm canTerm;
        ArrayList<Term> termList = null;
        Term curTerm = null;
        ArrayList canTermList = this.searchAllCandidates(start, end, this.minScore);
        if (canTermList == null || canTermList.size() <= 0) {
            return null;
        }
        termList = new ArrayList<Term>();
        int i = canTermList.size() - 1;
        while (i >= 0) {
            canTerm = (CandidateTerm)canTermList.get(i);
            if (this.getSenseDisambiguationOption() && canTerm.getCandidateCUINum() > 1) {
                canTerm = this.disambiguateCandidateTerm(canTerm);
            }
            curTerm = this.generateTerm(canTerm, true);
            termList.add(curTerm);
            --i;
        }
        curTerm = (Term)termList.get(0);
        curTerm.setSubConcept(false);
        curTerm.getStartingWord().setAssociatedConcept(curTerm);
        end = curTerm.getEndingWord();
        Word curWord = start.next;
        while (curWord != null && curWord.getPosInSentence() <= end.getPosInSentence()) {
            if (!this.isStartingWord(curWord)) {
                curWord = curWord.next;
                continue;
            }
            canTermList = this.searchAllCandidates(curWord, end, this.subtermMinScore);
            if (canTermList != null) {
                i = canTermList.size() - 1;
                while (i >= 0) {
                    canTerm = (CandidateTerm)canTermList.get(i);
                    if (this.getSenseDisambiguationOption() && canTerm.getCandidateCUINum() > 1) {
                        canTerm = this.disambiguateCandidateTerm(canTerm);
                    }
                    curTerm = this.generateTerm(canTerm, true);
                    termList.add(curTerm);
                    --i;
                }
            }
            curWord = curWord.next;
        }
        return termList;
    }

    public Term findTerm(Word start) {
        return this.findTerm(start, null);
    }

    public Term findTerm(Word start, Word end) {
        ArrayList canTermList = this.searchAllCandidates(start, end, this.minScore);
        if (canTermList == null || canTermList.size() <= 0) {
            return null;
        }
        CandidateTerm canTerm = (CandidateTerm)canTermList.get(canTermList.size() - 1);
        if (this.getSenseDisambiguationOption() && canTerm.getCandidateCUINum() > 1) {
            canTerm = this.disambiguateCandidateTerm(canTerm);
        }
        return this.generateTerm(canTerm, false);
    }

    private Term generateTerm(CandidateTerm canTerm, boolean isSubTerm) {
        int i = 0;
        int candidateNum = canTerm.getCandidateCUINum();
        while (i < candidateNum && canTerm.getCandidateCUI(i).getScore() >= 1.0) {
            ++i;
        }
        if (i > 0) {
            candidateNum = i;
        }
        String[] arrCUI = new String[candidateNum];
        i = 0;
        while (i < candidateNum) {
            arrCUI[i] = ((UmlsCUI)this.cuiListByIndex.get(canTerm.getCandidateCUI(i).getIndex())).toString();
            ++i;
        }
        Term curTerm = new Term(canTerm.getStartingWord(), canTerm.getEndingWord());
        curTerm.setSubConcept(isSubTerm);
        if (!curTerm.isSubConcept()) {
            canTerm.getStartingWord().setAssociatedConcept(curTerm);
        }
        if (candidateNum <= 1 || canTerm.getCandidateCUI(1).getScore() < canTerm.getCandidateCUI(0).getScore()) {
            curTerm.setCUI(arrCUI[0]);
        }
        curTerm.setCandidateCUI(arrCUI);
        if (curTerm.getCUI() == null) {
            curTerm.setCandidateTUI(this.getSemanticType(curTerm.getCandidateCUI()));
        } else {
            curTerm.setCandidateTUI(this.getSemanticType(curTerm.getCUI()));
        }
        if (curTerm.getCandidateTUINum() == 1) {
            curTerm.setTUI(curTerm.getCandidateTUI(0));
        }
        return curTerm;
    }

    private CandidateTerm disambiguateCandidateTerm(CandidateTerm canTerm) {
        int candidateNum = canTerm.getCandidateCUINum();
        int[] arrCandidateCUI = new int[candidateNum];
        double[] arrCandidateScore = new double[candidateNum];
        int i = 0;
        while (i < candidateNum) {
            arrCandidateCUI[i] = canTerm.getCandidateCUI(i).getIndex();
            arrCandidateScore[i] = canTerm.getCandidateCUI(i).getScore();
            ++i;
        }
        ArrayList contextList = this.generateContextWindow(canTerm.getStartingWord().getParent(), canTerm.getStartingWord(), canTerm.getEndingWord());
        i = 0;
        while (i < contextList.size()) {
            Word curWord = (Word)contextList.get(i);
            int index = this.getIndexInTokenList(curWord);
            if (index >= 0) {
                int narrowedNum = 0;
                int j = 0;
                while (j < candidateNum) {
                    double d;
                    double score = this.wtMatrix.getDouble(index, arrCandidateCUI[j]);
                    if (d > 0.0) {
                        arrCandidateCUI[narrowedNum] = arrCandidateCUI[j];
                        arrCandidateScore[narrowedNum] = arrCandidateScore[j] + score;
                        ++narrowedNum;
                    }
                    ++j;
                }
                if (narrowedNum > 0) {
                    candidateNum = narrowedNum;
                }
            }
            ++i;
        }
        if (candidateNum < canTerm.getCandidateCUINum()) {
            canTerm = this.buildCandidateTerm(canTerm.getStartingWord(), canTerm.getEndingWord(), arrCandidateCUI, arrCandidateScore, candidateNum, this.minScore);
        }
        contextList.clear();
        return canTerm;
    }

    private ArrayList searchAllCandidates(Word start, Word end, double minScore) {
        int candidateNum;
        int j;
        int index = this.getIndexInTokenList(start);
        if (index < 0) {
            return null;
        }
        Sentence sent = start.getParent();
        Word curWord = start.next;
        if (end == null) {
            j = 0;
            while (j < 4 && curWord != null && end == null) {
                if (this.isBoundaryWord(curWord)) {
                    end = curWord.prev;
                }
                if (!curWord.isPunctuation()) {
                    ++j;
                }
                curWord = curWord.next;
            }
            if (curWord == null) {
                curWord = sent.getLastWord();
            }
            if (end == null) {
                end = curWord;
            }
        }
        if ((candidateNum = this.wtMatrix.getNonZeroNumInRow(index)) <= 0) {
            return null;
        }
        int[] arrCandidateCUI = this.wtMatrix.getNonZeroColumnsInRow(index);
        double[] arrCandidateScore = this.wtMatrix.getNonZeroDoubleScoresInRow(index);
        ArrayList<CandidateTerm> canTermList = new ArrayList<CandidateTerm>(3);
        CandidateTerm canTerm = this.buildCandidateTerm(start, start, arrCandidateCUI, arrCandidateScore, candidateNum, minScore);
        if (canTerm != null) {
            canTermList.add(canTerm);
        }
        curWord = start.next;
        int skippedWords = 0;
        while (curWord != null && skippedWords <= this.maxSkippedWords && curWord.getPosInSentence() <= end.getPosInSentence()) {
            if (!this.isUsefulForTerm(curWord)) {
                curWord = curWord.next;
                continue;
            }
            index = this.getIndexInTokenList(curWord);
            if (index < 0) {
                curWord = curWord.next;
                ++skippedWords;
                continue;
            }
            int narrowedNum = 0;
            j = 0;
            while (j < candidateNum) {
                double d;
                double score = this.wtMatrix.getDouble(index, arrCandidateCUI[j]);
                if (d > 0.0) {
                    arrCandidateCUI[narrowedNum] = arrCandidateCUI[j];
                    arrCandidateScore[narrowedNum] = arrCandidateScore[j] + score;
                    ++narrowedNum;
                }
                ++j;
            }
            if (narrowedNum > 0) {
                candidateNum = narrowedNum;
                canTerm = this.buildCandidateTerm(start, curWord, arrCandidateCUI, arrCandidateScore, candidateNum, minScore);
                if (canTerm != null) {
                    canTermList.add(canTerm);
                }
                skippedWords = 0;
            } else {
                ++skippedWords;
            }
            curWord = curWord.next;
        }
        return canTermList;
    }

    private ArrayList generateContextWindow(Sentence sent, Word start, Word end) {
        ArrayList<Word> contexts = new ArrayList<Word>(6);
        Word cur = start.prev;
        int i = 0;
        while (i < 3 && cur != null) {
            if (cur.getPOSIndex() == 1 || cur.getPOSIndex() == 3) {
                contexts.add(cur);
                ++i;
            }
            cur = cur.prev;
        }
        cur = start.next;
        i = 0;
        while (i < 3 && cur != null) {
            if (cur.getPOSIndex() == 1 || cur.getPOSIndex() == 3) {
                contexts.add(cur);
                ++i;
            }
            cur = cur.next;
        }
        return contexts;
    }

    private CandidateTerm buildCandidateTerm(Word starting, Word ending, int[] arrCandidateCUI, double[] arrCandidateScore, int candidateNum, double minScore) {
        if (!(ending.getPOSIndex() != 3 || this.getAdjectiveTermOption() && ending.equals(starting))) {
            return null;
        }
        if (ending.getPOSIndex() == 9 && ending.equals(starting)) {
            return null;
        }
        if (1.0 / (double)candidateNum < this.minSelectivity) {
            return null;
        }
        CandidateTerm cTerm = new CandidateTerm(starting, ending);
        int i = 0;
        while (i < candidateNum) {
            if (arrCandidateScore[i] >= minScore) {
                cTerm.addCandidateCUI(new CandidateCUI(arrCandidateCUI[i], arrCandidateScore[i]));
            }
            ++i;
        }
        if (cTerm.getCandidateCUINum() > 0) {
            if (ending.getPOSIndex() == 3 && cTerm.getCandidateCUI(0).getScore() < 1.0) {
                return null;
            }
            return cTerm;
        }
        return null;
    }

    private int getIndexInTokenList(Word word) {
        if (word.getIndex() == Integer.MIN_VALUE) {
            Token token2 = this.tokenList.lookup(this.getLemma(word));
            if (token2 == null) {
                word.setIndex(-1);
            } else {
                word.setIndex(token2.getIndex());
            }
        }
        return word.getIndex();
    }

    private class CandidateTerm {
        Word starting;
        Word ending;
        SortedArray candidates;

        public CandidateTerm(Word starting, Word ending) {
            this.starting = starting;
            this.ending = ending;
            this.candidates = new SortedArray();
        }

        public void addCandidateCUI(CandidateCUI cui) {
            this.candidates.add(cui);
        }

        public Word getStartingWord() {
            return this.starting;
        }

        public Word getEndingWord() {
            return this.ending;
        }

        public CandidateCUI getCandidateCUI(int index) {
            return (CandidateCUI)this.candidates.get(index);
        }

        public int getCandidateCUINum() {
            return this.candidates.size();
        }
    }

    private class CandidateCUI
    implements Comparable {
        private int index;
        private double score;

        public CandidateCUI(int index, double score) {
            this.index = index;
            this.score = score;
        }

        public double getScore() {
            return this.score;
        }

        public int getIndex() {
            return this.index;
        }

        public int compareTo(Object obj) {
            double objScore = ((CandidateCUI)obj).getScore();
            if (this.score > objScore) {
                return -1;
            }
            if (this.score < objScore) {
                return 1;
            }
            int objIndex = ((CandidateCUI)obj).getIndex();
            if (this.index > objIndex) {
                return 1;
            }
            if (this.index < objIndex) {
                return -1;
            }
            return 0;
        }
    }
}

