/*
 * Decompiled with CFR 0.152.
 */
package dragon.nlp.ontology.mesh;

import dragon.matrix.DoubleSuperSparseMatrix;
import dragon.nlp.Term;
import dragon.nlp.Token;
import dragon.nlp.compare.AlphabetaComparator;
import dragon.nlp.ontology.SimilarityMetric;
import dragon.nlp.ontology.mesh.MeshNode;
import dragon.nlp.ontology.mesh.MeshNodeList;
import dragon.util.SortedArray;
import java.util.ArrayList;
import java.util.Date;

public class MeshSimilarity
implements SimilarityMetric {
    public static final int MIN_LEN = 0;
    public static final int WU_PALMER = 1;
    public static final int LI = 2;
    public static final int LEACOCK = 3;
    public static final int JING = 4;
    public static final int LIN = 5;
    public static final int JIANG = 6;
    public static final int RESINK = 7;
    public static final int MAO = 8;
    public static final int FEATURE = 9;
    public static final int KNAPPE = 10;
    private MeshNodeList meshNodeList;
    private SortedArray maxTaxoLenList;
    private int similarityMode;

    public MeshSimilarity(String hierFile, int similarityMode) {
        this.meshNodeList = new MeshNodeList(hierFile);
        this.maxTaxoLenList = similarityMode == 3 ? this.genMaxTaxoLenList() : null;
        this.similarityMode = similarityMode;
    }

    public String getParent(String path) {
        if (path.indexOf(".") < 0) {
            return null;
        }
        return path.substring(0, path.lastIndexOf("."));
    }

    public String[] getAncestors(String path) {
        if (path.indexOf(".") < 0) {
            String[] ancestors = new String[]{path};
            return ancestors;
        }
        ArrayList<String> parents = new ArrayList<String>(5);
        while (path.indexOf(".") > 0) {
            path = path.substring(0, path.lastIndexOf("."));
            parents.add(path);
        }
        String[] ancestors = new String[parents.size()];
        int i = 0;
        while (i < ancestors.length) {
            ancestors[i] = (String)parents.get(i);
            ++i;
        }
        return ancestors;
    }

    public String[] getSharedAncestors(String path1, String path2) {
        if (path1.equals(path2)) {
            return this.getAncestors(path1);
        }
        String[] ancestors1 = this.getAncestors(path1);
        String[] ancestors2 = this.getAncestors(path2);
        ArrayList<String> sharedParents = new ArrayList<String>(5);
        int i = 0;
        while (i < ancestors1.length) {
            int j = 0;
            while (j < ancestors2.length) {
                if (ancestors1[i].equals(ancestors2[j])) {
                    sharedParents.add(ancestors1[i]);
                }
                ++j;
            }
            ++i;
        }
        if (sharedParents.size() == 0) {
            return null;
        }
        String[] sharedAncestors = new String[sharedParents.size()];
        i = 0;
        while (i < sharedAncestors.length) {
            sharedAncestors[i] = (String)sharedParents.get(i);
            ++i;
        }
        return sharedAncestors;
    }

    public String[] getUnionAncestors(String path1, String path2) {
        if (path1.equals(path2)) {
            return this.getAncestors(path1);
        }
        String[] ancestors1 = this.getAncestors(path1);
        String[] ancestors2 = this.getAncestors(path2);
        SortedArray unionParents = new SortedArray(new AlphabetaComparator());
        int i = 0;
        while (i < ancestors1.length) {
            unionParents.add(ancestors1[i]);
            ++i;
        }
        i = 0;
        while (i < ancestors2.length) {
            unionParents.add(ancestors2[i]);
            ++i;
        }
        String[] unionAncestors = new String[unionParents.size()];
        i = 0;
        while (i < unionAncestors.length) {
            unionAncestors[i] = (String)unionParents.get(i);
            ++i;
        }
        return unionAncestors;
    }

    public String getRoot(String path) {
        if (path.indexOf(".") < 0) {
            return path;
        }
        return path.substring(0, path.indexOf("."));
    }

    public boolean isRoot(String path) {
        return path.indexOf(".") < 0;
    }

    /*
     * Unable to fully structure code
     */
    public String getCommonParent(String path1, String path2) {
        if (!this.getRoot(path1).equals(this.getRoot(path2))) {
            return null;
        }
        if (this.getDepth(path2) <= this.getDepth(path1)) ** GOTO lbl16
        temp = path1;
        path1 = path2;
        path2 = temp;
        ** GOTO lbl16
        {
            if (path1.indexOf(path2) >= 0) {
                return path2;
            }
            if (path2.indexOf(path1) >= 0) {
                return path1;
            }
            path2 = this.getParent(path2);
            do {
                if (path2 != null) continue block0;
                path1 = this.getParent(path1);
lbl16:
                // 3 sources

            } while (path1 != null);
        }
        return null;
    }

    public int getDescendantNum(String path) {
        MeshNode cur = this.meshNodeList.lookup(path);
        if (cur == null) {
            return 0;
        }
        return cur.getDescendantNum();
    }

    public ArrayList getDescendant(String path) {
        int pos = this.meshNodeList.binarySearch(new MeshNode(path));
        ArrayList<MeshNode> nodeList = new ArrayList<MeshNode>();
        MeshNode cur = (MeshNode)this.meshNodeList.get(pos);
        while (pos <= this.meshNodeList.size() - 2) {
            MeshNode child;
            if (!(child = (MeshNode)this.meshNodeList.get(++pos)).getPath().startsWith(cur.getPath())) break;
            nodeList.add(child);
        }
        return nodeList;
    }

    public int getMaxPathLen(String path) {
        ArrayList nodeList = this.getDescendant(path);
        if (nodeList.size() == 0) {
            return this.getDepth(path);
        }
        int max2 = 0;
        int i = 0;
        while (i < nodeList.size()) {
            int length = this.getDepth(((MeshNode)nodeList.get(i)).getPath());
            if (max2 < length) {
                max2 = length;
            }
            ++i;
        }
        return max2;
    }

    public int getMinLen(String path1, String path2) {
        String coParent = this.getCommonParent(path1, path2);
        if (coParent == null) {
            return -1;
        }
        int parLen = this.getDepth(coParent);
        return this.getDepth(path1) + this.getDepth(path2) - 2 * parLen;
    }

    public int getMinLen(String path1, String path2, String coParent) {
        if (coParent == null) {
            return -1;
        }
        int parLen = this.getDepth(coParent);
        return this.getDepth(path1) + this.getDepth(path2) - 2 * parLen;
    }

    public int getDepth(String path) {
        if (path.indexOf(".") < 0) {
            return 1;
        }
        int count2 = 0;
        while (this.getParent(path) != null) {
            path = this.getParent(path);
            ++count2;
        }
        return ++count2;
    }

    private double getWuPalmerSimilarity(String path1, String path2) {
        String coParent = this.getCommonParent(path1, path2);
        if (coParent == null) {
            return -1.0;
        }
        int parLen = this.getDepth(coParent);
        return (double)(2 * parLen) / (double)(this.getDepth(path1) - parLen + this.getDepth(path2) - parLen + 2 * parLen);
    }

    private double getLiSimilarity(String path1, String path2, double minPathScaler, double parentDepthScaler) {
        String coParent = this.getCommonParent(path1, path2);
        if (coParent == null) {
            return -1.0;
        }
        int parentDepth = this.getDepth(coParent);
        int path1Depth = this.getDepth(path1);
        int path2Depth = this.getDepth(path2);
        double minLen = path1Depth + path2Depth - 2 * parentDepth;
        double dist = Math.exp(-minPathScaler * minLen);
        dist *= Math.exp(parentDepthScaler * (double)parentDepth) - Math.exp(-parentDepthScaler * (double)parentDepth);
        return dist /= Math.exp(parentDepthScaler * (double)parentDepth) + Math.exp(-parentDepthScaler * (double)parentDepth);
    }

    private double getFeatureSimilarity(String path1, String path2) {
        String[] sharedAncestors = this.getSharedAncestors(path1, path2);
        if (sharedAncestors == null) {
            return 0.0;
        }
        double join = sharedAncestors.length;
        double union2 = this.getUnionAncestors(path1, path2).length;
        return (join + 1.0) / (union2 + 1.0);
    }

    private double getKnappeSimilarity(String path1, String path2) {
        if (path1.equals(path2)) {
            return 1.0;
        }
        String[] ancestors1 = this.getAncestors(path1);
        String[] ancestors2 = this.getAncestors(path2);
        String[] sharedAncestors = this.getSharedAncestors(path1, path2);
        if (sharedAncestors == null) {
            return 0.0;
        }
        double join = sharedAncestors.length;
        double gen = ancestors1.length;
        double speci = ancestors2.length;
        return 0.5 * (join / gen) + 0.5 * (join / speci);
    }

    private double getLeacockSimilarity(String path1, String path2) {
        String coParent = this.getCommonParent(path1, path2);
        if (coParent == null) {
            return -1.0;
        }
        int minLen = this.getMinLen(path1, path2, coParent);
        String root2 = this.getRoot(coParent);
        int pos = this.maxTaxoLenList.binarySearch(root2);
        Token token2 = (Token)this.maxTaxoLenList.get(pos);
        double value2 = (double)(minLen + 1) / 2.0 / token2.getWeight();
        return -Math.log(value2);
    }

    private double getJingSimilarity(String path1, String path2) {
        String coParent = this.getCommonParent(path1, path2);
        if (coParent == null) {
            return -1.0;
        }
        double coParentDepth = this.getDepth(coParent);
        double dist = 1.0 / coParentDepth;
        dist *= 0.5;
        return 1.0 - (dist *= ((double)this.getDepth(path1) - coParentDepth) / (double)this.getMaxPathLen(path1) + ((double)this.getDepth(path2) - coParentDepth) / (double)this.getMaxPathLen(path2));
    }

    private double getLinSimilarity(String path1, String path2) {
        if (path1.equals(path2)) {
            return 1.0;
        }
        String coParent = this.getCommonParent(path1, path2);
        if (coParent == null) {
            return -1.0;
        }
        return 2.0 * this.meshNodeList.lookup(coParent).getWeight() / (this.meshNodeList.lookup(path1).getWeight() + this.meshNodeList.lookup(path2).getWeight());
    }

    private double getJiangSimilarity(String path1, String path2) {
        String coParent = this.getCommonParent(path1, path2);
        if (coParent == null) {
            return -1.0;
        }
        return -this.meshNodeList.lookup(path1).getWeight() - this.meshNodeList.lookup(path2).getWeight() + 2.0 * this.meshNodeList.lookup(coParent).getWeight();
    }

    private double getResinkSimilarity(String path1, String path2) {
        if (path1.equals(path2)) {
            double dist = -this.meshNodeList.lookup(path1).getWeight();
            if (dist == 0.0) {
                dist = 0.11;
            }
            return dist;
        }
        String coParent = this.getCommonParent(path1, path2);
        if (coParent == null) {
            return -1.0;
        }
        double dist = -this.meshNodeList.lookup(coParent).getWeight();
        if (dist == 0.0) {
            dist = 0.11;
        }
        return dist;
    }

    private double getMaoSimilarity(String path1, String path2) {
        double len = this.getMinLen(path1, path2);
        if (len == 0.0) {
            return 1.0;
        }
        if (len == -1.0) {
            return -1.0;
        }
        int c1 = this.getDescendantNum(path1);
        int c2 = this.getDescendantNum(path2);
        return 0.9 / len / Math.log(2 + c1 + c2);
    }

    public MeshNodeList getMeshNodeList() {
        return this.meshNodeList;
    }

    private SortedArray genMaxTaxoLenList() {
        Token token2;
        SortedArray maxTaxoLenList = new SortedArray(107, new AlphabetaComparator());
        String oldRoot = "A01";
        String maxPath = "A01";
        double max2 = 0.0;
        int i = 0;
        while (i < this.meshNodeList.size()) {
            int depth;
            MeshNode meshNode = (MeshNode)this.meshNodeList.get(i);
            String curRoot = this.getRoot(meshNode.getPath());
            if (!curRoot.equals(oldRoot)) {
                token2 = new Token(this.getRoot(maxPath));
                token2.setWeight(max2);
                maxTaxoLenList.add(token2);
                max2 = 0.0;
                oldRoot = curRoot;
            }
            if (max2 < (double)(depth = this.getDepth(meshNode.getPath()))) {
                max2 = depth;
                maxPath = meshNode.getPath();
            }
            oldRoot = curRoot;
            ++i;
        }
        maxTaxoLenList.add(new Token(this.getRoot(maxPath)));
        ((Token)maxTaxoLenList.get(maxTaxoLenList.size() - 1)).setWeight(max2);
        i = 0;
        while (i < maxTaxoLenList.size()) {
            token2 = (Token)maxTaxoLenList.get(i);
            ++i;
        }
        return maxTaxoLenList;
    }

    public void trainWeightByInformationContent(ArrayList trainings) {
        MeshNode node;
        int i = 0;
        while (i < this.meshNodeList.size()) {
            node = (MeshNode)this.meshNodeList.get(i);
            node.setFrequency(0);
            ++i;
        }
        i = 0;
        while (i < trainings.size()) {
            node = (MeshNode)trainings.get(i);
            String cur = node.getPath();
            this.meshNodeList.lookup(cur).addFrequency(node.getFrequency());
            while (this.getParent(cur) != null) {
                cur = this.getParent(cur);
                this.meshNodeList.lookup(cur).addFrequency(node.getFrequency());
            }
            ++i;
        }
        i = 0;
        while (i < this.meshNodeList.size()) {
            node = (MeshNode)this.meshNodeList.get(i);
            if (node.getFrequency() == 0) {
                node.setWeight(0.0);
            } else {
                double ic = (double)node.getFrequency() / (double)this.meshNodeList.lookup(this.getRoot(node.getPath())).getFrequency();
                node.setWeight(Math.log(ic));
            }
            ++i;
        }
    }

    public void genSimilarityMatrix(String matrixFile, double threshold) {
        int start = 0;
        int end = 0;
        DoubleSuperSparseMatrix matrix = new DoubleSuperSparseMatrix(matrixFile, false, false);
        int i = 0;
        while (i < this.meshNodeList.size()) {
            MeshNode meshNodeI = (MeshNode)this.meshNodeList.get(i);
            if (meshNodeI.getPath().indexOf(".") < 0) {
                start = i;
                end = i + meshNodeI.getDescendantNum();
                System.out.println(new Date() + " " + start + " " + end);
            }
            int j = start;
            while (j < end) {
                MeshNode meshNodeJ = (MeshNode)this.meshNodeList.get(j);
                double dist = this.getSimilarity(meshNodeI.getPath(), meshNodeJ.getPath(), this.similarityMode);
                if (dist > threshold) {
                    matrix.add(i, j, dist);
                    matrix.add(j, i, dist);
                }
                ++j;
            }
            ++i;
        }
        matrix.finalizeData();
    }

    private double getSimilarity(String path1, String path2, int mode) {
        if (mode == 0) {
            return this.getMinLen(path1, path2);
        }
        if (mode == 1) {
            return this.getWuPalmerSimilarity(path1, path2);
        }
        if (mode == 2) {
            return this.getLiSimilarity(path1, path2, 0.6, 0.2);
        }
        if (mode == 3) {
            return this.getLeacockSimilarity(path1, path2);
        }
        if (mode == 4) {
            return this.getJingSimilarity(path1, path2);
        }
        if (mode == 5) {
            return this.getLinSimilarity(path1, path2);
        }
        if (mode == 6) {
            return this.getJiangSimilarity(path1, path2);
        }
        if (mode == 7) {
            return this.getResinkSimilarity(path1, path2);
        }
        if (mode == 8) {
            return this.getMaoSimilarity(path1, path2);
        }
        if (mode == 9) {
            return this.getFeatureSimilarity(path1, path2);
        }
        if (mode == 10) {
            return this.getKnappeSimilarity(path1, path2);
        }
        return -1.0;
    }

    public double getSimilarity(String path1, String path2) {
        return this.getSimilarity(path1, path2, this.similarityMode);
    }

    public double getSimilarity(Term a, Term b) {
        return this.getSimilarity(a.getCUI(), b.getCUI(), this.similarityMode);
    }
}

