/*
 * Decompiled with CFR 0.152.
 */
package dragon.nlp.ontology.mesh;

import dragon.nlp.ontology.BasicOntology;
import dragon.nlp.ontology.SimilarityMetric;
import dragon.nlp.ontology.mesh.MeshSimilarity;
import dragon.nlp.tool.Lemmatiser;
import dragon.util.EnvVariable;
import dragon.util.FileUtil;

public class BasicMeshOntology
extends BasicOntology {
    private MeshSimilarity metric;

    public BasicMeshOntology(Lemmatiser lemmatiser, int similarityMode) {
        this(lemmatiser, similarityMode, EnvVariable.getDragonHome() + "/nlpdata/mesh/mesh.hier", EnvVariable.getDragonHome() + "/nlpdata/mesh/mesh.cui");
    }

    public BasicMeshOntology(Lemmatiser lemmatiser, int similarityMode, String hierFile, String conceptFile) {
        super(conceptFile, lemmatiser);
        if (!FileUtil.exist(hierFile) && FileUtil.exist(EnvVariable.getDragonHome() + "/" + hierFile)) {
            hierFile = EnvVariable.getDragonHome() + "/" + hierFile;
        }
        this.metric = new MeshSimilarity(hierFile, similarityMode);
    }

    public SimilarityMetric getSimilarityMetric() {
        return this.metric;
    }
}

