/*
 * Decompiled with CFR 0.152.
 */
package dragon.nlp.ontology;

import dragon.nlp.ontology.BasicTerm;
import dragon.util.FileUtil;
import dragon.util.SortedArray;
import java.io.BufferedReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;

public class BasicTermList
extends SortedArray {
    private static final long serialVersionUID = 1L;

    public BasicTermList(String cuiFile) {
        this.loadTermList(cuiFile);
    }

    public BasicTerm termAt(int index) {
        return (BasicTerm)this.get(index);
    }

    public BasicTerm lookup(String term) {
        int pos = this.binarySearch(new BasicTerm(0, term, null));
        if (pos < 0) {
            return null;
        }
        return (BasicTerm)this.get(pos);
    }

    public BasicTerm lookup(BasicTerm term) {
        int pos = this.binarySearch(term);
        if (pos < 0) {
            return null;
        }
        return (BasicTerm)this.get(pos);
    }

    private boolean loadTermList(String filename) {
        try {
            if (filename == null) {
                return false;
            }
            System.out.println(new Date() + " Loading Term List...");
            BufferedReader br = FileUtil.getTextReader(filename);
            String line = br.readLine();
            int total = Integer.parseInt(line);
            ArrayList<BasicTerm> list2 = new ArrayList<BasicTerm>(total);
            int i = 0;
            while (i < total) {
                line = br.readLine();
                String[] arrField = line.split("\t");
                BasicTerm cur = new BasicTerm(i, arrField[1], arrField[2].split("_"));
                list2.add(cur);
                ++i;
            }
            br.close();
            Collections.sort(list2);
            this.addAll(list2);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }
}

