/*
 * Decompiled with CFR 0.152.
 */
package dragon.nlp.ontology;

import dragon.nlp.Sentence;
import dragon.nlp.Term;
import dragon.nlp.Word;
import dragon.nlp.ontology.AbstractOntology;
import dragon.nlp.ontology.BasicTerm;
import dragon.nlp.ontology.BasicTermList;
import dragon.nlp.tool.Lemmatiser;
import dragon.util.EnvVariable;
import dragon.util.FileUtil;
import java.util.ArrayList;

public class BasicOntology
extends AbstractOntology {
    private BasicTermList list;

    public BasicOntology(String termFilename, Lemmatiser lemmatiser) {
        super(lemmatiser);
        if (!FileUtil.exist(termFilename) && FileUtil.exist(EnvVariable.getDragonHome() + "/" + termFilename)) {
            termFilename = EnvVariable.getDragonHome() + "/" + termFilename;
        }
        this.setNonBoundaryPunctuation(".-");
        this.list = new BasicTermList(termFilename);
    }

    public String[] getSemanticType(String[] cuis) {
        return null;
    }

    public String[] getSemanticType(String cui) {
        return null;
    }

    public String[] getCUI(String term) {
        BasicTerm cur = this.list.lookup(term);
        if (cur == null) {
            return null;
        }
        return cur.getAllCUI();
    }

    public String[] getCUI(Word starting, Word ending) {
        return this.getCUI(this.buildString(starting, ending, this.getLemmaOption()));
    }

    public boolean isTerm(String term) {
        return true;
    }

    public boolean isTerm(Word starting, Word ending) {
        return this.isTerm(this.buildString(starting, ending, this.getLemmaOption()));
    }

    public Term findTerm(Word starting) {
        return this.findTerm(starting, null);
    }

    public Term findTerm(Word start, Word end) {
        Sentence sent = start.getParent();
        Word curWord = start.next;
        if (end == null) {
            int j = 0;
            while (j < 4 && curWord != null && end == null) {
                if (this.isBoundaryWord(curWord)) {
                    end = curWord.prev;
                }
                ++j;
                curWord = curWord.next;
            }
            if (curWord == null) {
                curWord = sent.getLastWord();
            }
            if (end == null) {
                end = curWord;
            }
        }
        curWord = end;
        String[] arrCandidateCUI = null;
        while (curWord != null && curWord.getPosInSentence() >= start.getPosInSentence()) {
            int posIndex = curWord.getPOSIndex();
            if ((posIndex == 1 || posIndex == 9 && curWord.getPosInSentence() > start.getPosInSentence()) && (arrCandidateCUI = this.getCUI(start, curWord)) != null) break;
            curWord = curWord.prev;
        }
        if (arrCandidateCUI == null) {
            return null;
        }
        Term curTerm = new Term(start, curWord);
        start.setAssociatedConcept(curTerm);
        curTerm.setCandidateCUI(arrCandidateCUI);
        if (arrCandidateCUI.length == 1) {
            curTerm.setCUI(arrCandidateCUI[0]);
        }
        return curTerm;
    }

    public ArrayList findAllTerms(Word starting) {
        return this.findAllTerms(starting, null);
    }

    public ArrayList findAllTerms(Word starting, Word ending) {
        Term cur = this.findTerm(starting, ending);
        if (cur == null) {
            return null;
        }
        ArrayList<Term> termList = new ArrayList<Term>(1);
        termList.add(cur);
        return termList;
    }
}

