/*
 * Decompiled with CFR 0.152.
 */
package dragon.nlp.extract;

import dragon.nlp.Sentence;
import dragon.nlp.Token;
import dragon.nlp.Word;
import dragon.nlp.extract.AbstractTokenExtractor;
import dragon.nlp.extract.BasicConceptFilter;
import dragon.nlp.tool.Lemmatiser;
import dragon.util.SortedArray;
import java.util.ArrayList;

public class BasicTokenExtractor
extends AbstractTokenExtractor {
    public BasicTokenExtractor(Lemmatiser lemmatiser) {
        super(lemmatiser);
    }

    public BasicTokenExtractor(Lemmatiser lemmatiser, String stoplistFile) {
        super(lemmatiser);
        this.setConceptFilter(new BasicConceptFilter(stoplistFile));
    }

    public ArrayList extractFromDoc(String content) {
        ArrayList list2 = this.parser.parseTokens(content);
        this.conceptList = new ArrayList();
        if (list2 == null) {
            return this.conceptList;
        }
        int i = 0;
        while (i < list2.size()) {
            String value2 = (String)list2.get(i);
            this.addToken(value2, this.conceptList);
            ++i;
        }
        list2.clear();
        return this.conceptList;
    }

    public ArrayList extractFromSentence(Sentence sent) {
        SortedArray tokenList = new SortedArray();
        Word cur = sent.getFirstWord();
        while (cur != null) {
            if (cur.getType() != 4) {
                this.addToken(new String(cur.getContent()), tokenList);
            }
            cur = cur.next;
        }
        return tokenList;
    }

    private Token addToken(String value2, ArrayList tokenList) {
        if (this.lemmatiser != null) {
            value2 = this.lemmatiser.lemmatize(value2);
        }
        if (this.conceptFilter_enabled && !this.cf.keep(value2)) {
            return null;
        }
        Token token2 = new Token(value2);
        tokenList.add(token2);
        return token2;
    }
}

