/*
 * Decompiled with CFR 0.152.
 */
package dragon.nlp.extract;

import dragon.nlp.Term;
import dragon.nlp.Word;
import dragon.util.FileUtil;
import dragon.util.SortedArray;
import java.util.ArrayList;

public class AttributeChecker {
    private SortedArray attributes;

    public AttributeChecker(String attributeFile) {
        this.loadAttributes(attributeFile);
    }

    public boolean loadAttributes(String filename) {
        try {
            String content = FileUtil.readTextFile(filename);
            String[] arrTerms = content.split("\r\n");
            int termNum = arrTerms.length;
            while (termNum > 0 && arrTerms[termNum - 1].trim().length() == 0) {
                --termNum;
            }
            this.attributes = new SortedArray(termNum);
            int i = 0;
            while (i < termNum) {
                this.attributes.add(i, arrTerms[i].toLowerCase());
                ++i;
            }
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean isAttribute(Term attr2) {
        return this.attributes.contains(attr2.toLemmaString());
    }

    public boolean isAttribute(String attr2) {
        return this.attributes.contains(attr2.toLowerCase());
    }

    public int identifyAttributes(ArrayList termList) {
        if (termList == null) {
            return 0;
        }
        if (termList.size() < 2) {
            return 0;
        }
        int count2 = 0;
        Term curTerm = (Term)termList.get(0);
        int i = 1;
        while (i < termList.size()) {
            Word word = curTerm.getEndingWord().next;
            Term nextTerm = (Term)termList.get(i);
            if (word.getPOSIndex() == 5 && "of for".indexOf(word.getContent().toLowerCase()) >= 0) {
                if (nextTerm.getStartingWord().getPosInSentence() - curTerm.getEndingWord().getPosInSentence() > 4 || this.isAttribute(curTerm)) {
                    // empty if block
                }
                curTerm.getStartingWord().setAssociatedConcept(null);
                nextTerm.addAttribute(curTerm);
                ++count2;
                termList.remove(i - 1);
                --i;
                int groupNo = nextTerm.getEndingWord().getParallelGroup();
                if (groupNo > curTerm.getEndingWord().getParallelGroup()) {
                    int j = i + 1;
                    while (j < termList.size()) {
                        Term term = (Term)termList.get(j);
                        if (term.getEndingWord().getParallelGroup() != groupNo) break;
                        term.addAttribute(curTerm);
                        ++j;
                    }
                    i = j - 1;
                }
                curTerm = (Term)termList.get(i);
            } else {
                curTerm = nextTerm;
            }
            ++i;
        }
        return count2;
    }
}

