/*
 * Decompiled with CFR 0.152.
 */
package dragon.nlp.extract;

import dragon.nlp.extract.AbstractConceptExtractor;
import dragon.nlp.extract.PhraseExtractor;
import dragon.nlp.ontology.Vocabulary;
import dragon.nlp.tool.Lemmatiser;
import dragon.nlp.tool.Tagger;

public abstract class AbstractPhraseExtractor
extends AbstractConceptExtractor
implements PhraseExtractor {
    protected Lemmatiser lemmatiser;
    protected Tagger tagger;
    protected Vocabulary vocabulary;
    protected boolean useNoun;
    protected boolean useAdj;
    protected boolean useVerb;

    public AbstractPhraseExtractor(Vocabulary vocabulary, Tagger tagger, Lemmatiser lemmatiser) {
        this.lemmatiser = lemmatiser;
        this.tagger = tagger;
        this.vocabulary = vocabulary;
        this.useNoun = false;
        this.useAdj = false;
        this.useVerb = false;
    }

    public void setSingleNounOption(boolean option) {
        this.useNoun = option;
    }

    public boolean getSingleNounOption() {
        return this.useNoun;
    }

    public void setSingleVerbOption(boolean option) {
        this.useVerb = option;
    }

    public boolean getSingleVerbOption() {
        return this.useVerb;
    }

    public void setSingleAdjectiveOption(boolean option) {
        this.useAdj = option;
    }

    public boolean getSingleAdjectiveOption() {
        return this.useAdj;
    }

    public boolean supportConceptName() {
        return true;
    }

    public boolean supportConceptEntry() {
        return false;
    }

    public Lemmatiser getLemmatiser() {
        return this.lemmatiser;
    }

    public void setLemmatiser(Lemmatiser lemmatiser) {
        this.lemmatiser = lemmatiser;
    }

    public Tagger getPOSTagger() {
        return this.tagger;
    }

    public Vocabulary getVocabulary() {
        return this.vocabulary;
    }

    public void initDocExtraction() {
    }
}

