/*
 * Decompiled with CFR 0.152.
 */
package dragon.nlp.extract;

import dragon.nlp.DocumentParser;
import dragon.nlp.extract.DualConceptExtractor;
import dragon.nlp.extract.EngDocumentParser;
import dragon.onlinedb.Article;
import java.util.ArrayList;

public abstract class AbstractDualConceptExtractor
implements DualConceptExtractor {
    protected ArrayList firstConceptList;
    protected ArrayList secondConceptList;
    protected DocumentParser parser = new EngDocumentParser();

    public boolean extractFromDoc(Article article) {
        return this.extractFromDoc(this.getArticleContent(article));
    }

    public boolean extractFromDoc(String doc) {
        return this.extractFromDoc(this.parser.parse(doc));
    }

    public ArrayList getFirstConceptList() {
        return this.firstConceptList;
    }

    public ArrayList getSecondConceptList() {
        return this.secondConceptList;
    }

    public boolean isExtractionMerged() {
        return false;
    }

    public boolean supportConceptName() {
        return true;
    }

    public boolean supportConceptEntry() {
        return false;
    }

    public void initDocExtraction() {
        this.firstConceptList = new ArrayList(100);
        this.secondConceptList = new ArrayList(100);
    }

    protected String getArticleContent(Article article) {
        StringBuffer sb = new StringBuffer();
        if (article.getTitle() != null && article.getTitle().length() >= 5) {
            if (sb.length() > 0) {
                sb.append("\n\n");
            }
            sb.append(article.getTitle());
        }
        if (article.getMeta() != null && article.getMeta().length() >= 5) {
            if (sb.length() > 0) {
                sb.append("\n\n");
            }
            sb.append(article.getMeta());
        }
        if (article.getAbstract() != null && article.getAbstract().length() >= 5) {
            if (sb.length() > 0) {
                sb.append("\n\n");
            }
            sb.append(article.getAbstract());
        }
        if (article.getBody() != null && article.getBody().length() >= 5) {
            if (sb.length() > 0) {
                sb.append("\n\n");
            }
            sb.append(article.getBody());
        }
        return sb.toString();
    }

    public DocumentParser getDocumentParser() {
        return this.parser;
    }

    public void setDocumentParser(DocumentParser parser) {
        this.parser = parser;
    }
}

