/*
 * Decompiled with CFR 0.152.
 */
package dragon.nlp.extract;

import dragon.nlp.Concept;
import dragon.nlp.Document;
import dragon.nlp.DocumentParser;
import dragon.nlp.Paragraph;
import dragon.nlp.Sentence;
import dragon.nlp.compare.ConceptEntryIDComparator;
import dragon.nlp.compare.ConceptNameComparator;
import dragon.nlp.extract.ConceptExtractor;
import dragon.nlp.extract.ConceptFilter;
import dragon.nlp.extract.EngDocumentParser;
import dragon.util.SortedArray;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Comparator;

public abstract class AbstractConceptExtractor
implements ConceptExtractor {
    protected ArrayList conceptList = null;
    protected boolean conceptFilter_enabled = false;
    protected boolean subconcept_enabled = false;
    protected ConceptFilter cf = null;
    protected DocumentParser parser = new EngDocumentParser();

    public void setSubConceptOption(boolean option) {
        this.subconcept_enabled = option;
    }

    public boolean getSubConceptOption() {
        return this.subconcept_enabled;
    }

    public boolean getFilteringOption() {
        return this.conceptFilter_enabled;
    }

    public void setFilteringOption(boolean option) {
        this.conceptFilter_enabled = option;
    }

    public void setConceptFilter(ConceptFilter cf) {
        this.cf = cf;
        this.conceptFilter_enabled = cf != null;
    }

    public ConceptFilter getConceptFilter() {
        return this.cf;
    }

    public ArrayList getConceptList() {
        return this.conceptList;
    }

    public void print(PrintWriter out) {
        if (this.conceptList == null || this.conceptList.size() == 0) {
            return;
        }
        this.print(out, this.conceptList);
    }

    public void print(PrintWriter out, ArrayList conceptList) {
        try {
            out.write(conceptList.size() + "\n");
            int i = 0;
            while (i < conceptList.size()) {
                Concept t = (Concept)conceptList.get(i);
                out.write(t.getName() + "\t" + t.getFrequency() + "\n");
                out.flush();
                ++i;
            }
            out.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public SortedArray mergeConceptByEntryID(ArrayList termList) {
        return this.mergeTerms(termList, new ConceptEntryIDComparator());
    }

    public SortedArray mergeConceptByName(ArrayList termList) {
        return this.mergeTerms(termList, new ConceptNameComparator());
    }

    private SortedArray mergeTerms(ArrayList termList, Comparator comparator) {
        SortedArray newList = new SortedArray(comparator);
        int i = 0;
        while (i < termList.size()) {
            Concept newTerm;
            Concept oldTerm = (Concept)termList.get(i);
            int pos = newList.binarySearch(oldTerm);
            if (pos >= 0) {
                newTerm = (Concept)newList.get(pos);
                newTerm.addFrequency(oldTerm.getFrequency());
            } else {
                pos = pos * -1 - 1;
                newTerm = oldTerm.copy();
                newTerm.setIndex(newList.size());
                newList.add(pos, newTerm);
            }
            ++i;
        }
        return newList;
    }

    public synchronized ArrayList extractFromDoc(String doc) {
        return this.extractFromDoc(this.parser.parse(doc));
    }

    public synchronized ArrayList extractFromDoc(Document doc) {
        try {
            this.conceptList = new ArrayList(20);
            if (doc == null) {
                return this.conceptList;
            }
            Paragraph pg = doc.getFirstParagraph();
            while (pg != null) {
                Sentence sent = pg.getFirstSentence();
                while (sent != null) {
                    ArrayList curTermList;
                    if (sent.getFirstWord() != null && (curTermList = this.extractFromSentence(sent)) != null) {
                        this.conceptList.addAll(curTermList);
                        curTermList.clear();
                    }
                    sent = sent.next;
                }
                pg = pg.next;
            }
            return this.conceptList;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public DocumentParser getDocumentParser() {
        return this.parser;
    }

    public void setDocumentParser(DocumentParser parser) {
        this.parser = parser;
    }
}

