/*
 * Decompiled with CFR 0.152.
 */
package dragon.nlp;

import dragon.nlp.Concept;
import dragon.nlp.Word;
import dragon.nlp.compare.SortedElement;

public class Token
implements Concept,
Comparable,
SortedElement {
    private String value;
    private int index;
    private int freq;
    private double weight;
    private Object memo;

    public Token(String value2) {
        this.freq = 1;
        this.value = value2;
        this.index = -1;
        this.weight = -1.0;
        this.memo = null;
    }

    public Token(int index, int frequency) {
        this.freq = frequency;
        this.index = index;
        this.weight = -1.0;
        this.value = null;
        this.memo = null;
    }

    public Token(String value2, int index, int frequency) {
        this.freq = frequency;
        this.value = value2;
        this.index = index;
        this.weight = -1.0;
        this.memo = null;
    }

    public Concept copy() {
        Token cur = new Token(this.value);
        cur.setFrequency(this.freq);
        cur.setIndex(this.index);
        cur.setWeight(this.weight);
        return cur;
    }

    public int getConceptType() {
        return 3;
    }

    public String getName() {
        return this.value;
    }

    public String getEntryID() {
        return this.value;
    }

    public String getSemanticType() {
        return null;
    }

    public boolean isSubConcept() {
        return false;
    }

    public Word getStartingWord() {
        return null;
    }

    public Word getEndingWord() {
        return null;
    }

    public Object getMemo() {
        return this.memo;
    }

    public void setMemo(Object memo) {
        this.memo = memo;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value2) {
        this.value = value2;
    }

    public void setFrequency(int freq) {
        this.freq = freq;
    }

    public void addFrequency(int inc) {
        this.freq += inc;
    }

    public int getFrequency() {
        return this.freq;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public void setWeight(double weight) {
        this.weight = weight;
    }

    public double getWeight() {
        return this.weight;
    }

    public int compareTo(Object obj) {
        String objValue = ((Token)obj).getValue();
        return this.value.compareToIgnoreCase(objValue);
    }

    public int compareTo(Token token2) {
        return this.value.compareToIgnoreCase(token2.getValue());
    }

    public boolean equals(Object obj) {
        if (this.value == null) {
            return this.index == ((Concept)obj).getIndex();
        }
        return this.value.equalsIgnoreCase(((Concept)obj).getName());
    }

    public boolean equalTo(Concept concept) {
        if (this.value == null) {
            return this.index == concept.getIndex();
        }
        return this.value.equalsIgnoreCase(concept.getName());
    }

    public String toString() {
        return this.value;
    }

    public int hashCode() {
        if (this.index >= 0) {
            return this.index;
        }
        return super.hashCode();
    }
}

