/*
 * Decompiled with CFR 0.152.
 */
package dragon.nlp;

import dragon.nlp.Concept;
import dragon.nlp.Word;
import dragon.nlp.compare.SortedElement;

public class Phrase
implements Concept,
Comparable,
SortedElement {
    public static final int NAME_ASIS = 0;
    public static final int NAME_LEMMA = 1;
    private static int nameMode = 0;
    private Word starting;
    private Word ending;
    private Object memo;
    private int freq;
    private double weight;
    private int len;
    private int index;
    private boolean subterm;

    public Phrase(Word starting, Word ending) {
        this.starting = starting;
        this.ending = ending;
        this.weight = 0.0;
        this.freq = 1;
        this.index = 0;
        this.len = 1;
        this.memo = null;
        this.subterm = false;
        Word next2 = starting;
        while (!next2.equals(ending)) {
            ++this.len;
            next2 = next2.next;
        }
    }

    public Phrase(Word word) {
        this.starting = word;
        this.ending = word;
        this.freq = 1;
        this.index = 0;
        this.memo = null;
        this.weight = 0.0;
        this.len = 1;
        this.subterm = false;
    }

    public Concept copy() {
        Phrase newTerm = new Phrase(this.getStartingWord(), this.getEndingWord());
        newTerm.setFrequency(this.getFrequency());
        newTerm.setSubConcept(this.isSubConcept());
        newTerm.setIndex(this.getIndex());
        newTerm.setWeight(this.getWeight());
        return newTerm;
    }

    public int getConceptType() {
        return 2;
    }

    public static void setNameMode(int mode) {
        if (mode < 0 || mode > 1) {
            return;
        }
        nameMode = mode;
    }

    public int compareTo(Object obj) {
        String objValue = ((Phrase)obj).toString();
        return this.toString().compareToIgnoreCase(objValue);
    }

    public int compareTo(Phrase term) {
        return this.toString().compareToIgnoreCase(term.toString());
    }

    public boolean isSubConcept() {
        return this.subterm;
    }

    public void setSubConcept(boolean subterm) {
        this.subterm = subterm;
    }

    public String getName() {
        if (nameMode == 0) {
            return this.toString();
        }
        return this.toLemmaString();
    }

    public String getEntryID() {
        return this.getName();
    }

    public String getSemanticType() {
        return null;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public void setWeight(double weight) {
        this.weight = weight;
    }

    public double getWeight() {
        return this.weight;
    }

    public Word getStartingWord() {
        return this.starting;
    }

    public Word getEndingWord() {
        return this.ending;
    }

    public Object getMemo() {
        return this.memo;
    }

    public void setMemo(Object memo) {
        this.memo = memo;
    }

    public String toString() {
        StringBuffer term = new StringBuffer(this.starting.getContent());
        Word next2 = this.starting;
        boolean lastPunctuation = false;
        while (!next2.equals(this.ending)) {
            next2 = next2.next;
            if (next2.isPunctuation()) {
                term.append(next2.getContent());
                lastPunctuation = true;
                continue;
            }
            if (lastPunctuation) {
                term.append(next2.getContent());
            } else {
                term.append(' ');
                term.append(next2.getContent());
            }
            lastPunctuation = false;
        }
        return term.toString();
    }

    public String toLemmaString() {
        Word next2 = this.starting;
        String term = next2.getLemma();
        while (!next2.equals(this.ending)) {
            next2 = next2.next;
            term = term + " " + next2.getLemma();
        }
        return term;
    }

    public int getWordNum() {
        return this.len;
    }

    public void addFrequency(int inc) {
        this.freq += inc;
    }

    public int getFrequency() {
        return this.freq;
    }

    public void setFrequency(int freq) {
        this.freq = freq;
    }

    public boolean equalTo(Concept concept) {
        return this.getName().equalsIgnoreCase(concept.getName());
    }
}

