/*
 * Decompiled with CFR 0.152.
 */
package dragon.ml.seqmodel.model;

import dragon.ml.seqmodel.data.DataSequence;
import dragon.ml.seqmodel.model.AbstractModel;
import dragon.ml.seqmodel.model.CompleteModel;
import dragon.ml.seqmodel.model.Edge;
import dragon.ml.seqmodel.model.EdgeIterator;
import dragon.ml.seqmodel.model.GenericModel;
import dragon.ml.seqmodel.model.ModelGraph;
import dragon.ml.seqmodel.model.NoEdgeModel;
import java.util.StringTokenizer;

public class NestedModel
extends AbstractModel {
    private int _numStates;
    private int _numEdges;
    private int[] nodeOffsets;
    private ModelGraph[] inner;
    private ModelGraph outer;
    private int[] startStates;
    private int[] endStates;

    public static void main(String[] args) {
        try {
            System.out.println(args[0]);
            System.out.println(args[1]);
            NestedModel model = new NestedModel(Integer.parseInt(args[0]), args[1]);
            System.out.println(((AbstractModel)model).getStateNum());
            System.out.println(model.getEdgeNum());
            System.out.println(model.getStartStateNum());
            System.out.println(model.getEndStateNum());
            EdgeIterator edgeIter = model.getEdgeIterator();
            int edgeNum = 0;
            while (edgeIter.hasNext()) {
                boolean edgeIsOuter = edgeIter.nextIsOuter();
                Edge e = edgeIter.next();
                System.out.println(e.getStart() + "(" + model.getLabel(e.getStart()) + ")" + " -> " + e.getEnd() + ":" + edgeIsOuter + ";");
                ++edgeNum;
            }
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            e.printStackTrace();
        }
    }

    public NestedModel(int labelNum, String specs) throws Exception {
        super(labelNum, "Nested");
        int j;
        this.nodeOffsets = new int[this.numLabels];
        this.inner = new AbstractModel[this.numLabels];
        StringTokenizer start = new StringTokenizer(specs, ",");
        this.outer = this.getNewBaseModel(this.numLabels, start.nextToken());
        String commonStruct = null;
        int i = 0;
        while (i < this.numLabels) {
            String thisStruct = commonStruct;
            if (thisStruct == null && (thisStruct = start.nextToken()).endsWith("*")) {
                commonStruct = thisStruct = thisStruct.substring(0, thisStruct.length() - 1);
            }
            this.inner[i] = new GenericModel(thisStruct, i);
            ++i;
        }
        this._numEdges = 0;
        this._numStates = 0;
        int l = 0;
        while (l < this.numLabels) {
            int n = l;
            this.nodeOffsets[n] = this.nodeOffsets[n] + this._numStates;
            this._numStates += this.inner[l].getStateNum();
            this._numEdges += this.inner[l].getEdgeNum();
            ++l;
        }
        EdgeIterator outerIter = this.outer.getEdgeIterator();
        while (outerIter.hasNext()) {
            Edge e = outerIter.next();
            this._numEdges += this.inner[e.getEnd()].getStartStateNum() * this.inner[e.getStart()].getEndStateNum();
        }
        int numStart = 0;
        i = 0;
        while (i < this.outer.getStartStateNum()) {
            numStart += this.inner[this.outer.getStartState(i)].getStartStateNum();
            ++i;
        }
        this.startStates = new int[numStart];
        int index = 0;
        i = 0;
        while (i < this.outer.getStartStateNum()) {
            j = 0;
            while (j < this.inner[this.outer.getStartState(i)].getStartStateNum()) {
                this.startStates[index++] = this.inner[this.outer.getStartState(i)].getStartState(j) + this.nodeOffsets[this.outer.getStartState(i)];
                ++j;
            }
            ++i;
        }
        int numEnd = 0;
        i = 0;
        while (i < this.outer.getEndStateNum()) {
            numEnd += this.inner[this.outer.getEndState(i)].getEndStateNum();
            ++i;
        }
        this.endStates = new int[numEnd];
        index = 0;
        i = 0;
        while (i < this.outer.getEndStateNum()) {
            j = 0;
            while (j < this.inner[this.outer.getEndState(i)].getEndStateNum()) {
                this.endStates[index++] = this.inner[this.outer.getEndState(i)].getEndState(j) + this.nodeOffsets[this.outer.getEndState(i)];
                ++j;
            }
            ++i;
        }
    }

    public EdgeIterator getEdgeIterator() {
        return new NestedEdgeIterator(this);
    }

    public EdgeIterator innerEdgeIterator() {
        return new NestedEdgeIterator(this, false);
    }

    public int getStateNum() {
        return this._numStates;
    }

    public int getEdgeNum() {
        return this._numEdges;
    }

    public int getLabel(int stateNum) {
        int i = 0;
        while (i < this.nodeOffsets.length) {
            if (stateNum < this.nodeOffsets[i]) {
                return i - 1;
            }
            ++i;
        }
        return this.nodeOffsets.length - 1;
    }

    public int getStartStateNum() {
        return this.startStates.length;
    }

    public int getEndStateNum() {
        return this.endStates.length;
    }

    public int getStartState(int i) {
        return i < this.getStartStateNum() ? this.startStates[i] : -1;
    }

    public int getEndState(int i) {
        return i < this.getEndStateNum() ? this.endStates[i] : -1;
    }

    public boolean isEndState(int i) {
        int k = 0;
        while (k < this.endStates.length) {
            if (this.endStates[k] == i) {
                return true;
            }
            ++k;
        }
        return false;
    }

    public boolean isStartState(int i) {
        int k = 0;
        while (k < this.startStates.length) {
            if (this.startStates[k] == i) {
                return true;
            }
            ++k;
        }
        return false;
    }

    public boolean mapStateToLabel(DataSequence dataSeq) {
        int dataLen = dataSeq.length();
        if (dataLen == 0) {
            return true;
        }
        int segStart = 0;
        int segEnd = 0;
        while (segStart < dataLen) {
            segEnd = segStart;
            while (segEnd < dataLen) {
                if (this.getLabel(dataSeq.getLabel(segStart)) != this.getLabel(dataSeq.getLabel(segEnd))) {
                    --segEnd;
                    System.out.println("WARNING: label ending in a state not marked as a End-state");
                    break;
                }
                if (this.isEndState(dataSeq.getLabel(segEnd))) break;
                ++segEnd;
            }
            if (segEnd == dataLen) {
                System.out.println("WARNING: End state not found until the last position");
                System.out.println(dataSeq);
                segEnd = dataLen - 1;
            }
            dataSeq.setSegment(segStart, segEnd, this.getLabel(dataSeq.getLabel(segStart)));
            segStart = segEnd + 1;
        }
        return true;
    }

    public boolean mapLabelToState(DataSequence data2) {
        if (data2.length() == 0) {
            return true;
        }
        int lstart = 0;
        while (lstart < data2.length()) {
            int lend = data2.getSegmentEnd(lstart) + 1;
            if (lend == 0) {
                return false;
            }
            int label = data2.getLabel(lstart);
            this.inner[label].mapLabelToState(data2, lend - lstart, lstart);
            int k = lstart;
            while (k < lend) {
                data2.setLabel(k, this.nodeOffsets[label] + data2.getLabel(k));
                ++k;
            }
            lstart = lend;
        }
        return true;
    }

    private ModelGraph getNewBaseModel(int numLabels, String modelSpecs) throws Exception {
        if (modelSpecs.equalsIgnoreCase("naive") || modelSpecs.equalsIgnoreCase("semi-markov")) {
            return new CompleteModel(numLabels);
        }
        if (modelSpecs.equalsIgnoreCase("noEdge")) {
            return new NoEdgeModel(numLabels);
        }
        throw new Exception("Base model can be one of {naive, noEdge, semi-Markov}");
    }

    private class NestedEdgeIterator
    implements EdgeIterator {
        private NestedModel model;
        private int label;
        private Edge edge;
        private EdgeIterator[] edgeIter;
        private EdgeIterator outerEdgeIter;
        private Edge outerEdge;
        private boolean outerEdgesSent;
        private int index1;
        private int index2;
        private boolean sendOuter;

        public NestedEdgeIterator(NestedModel m) {
            this(m, true);
        }

        public NestedEdgeIterator(NestedModel m, boolean sendOuter) {
            this.model = m;
            this.edge = new Edge();
            this.edgeIter = new EdgeIterator[this.model.numLabels];
            int l = 0;
            while (l < this.model.numLabels) {
                this.edgeIter[l] = this.model.inner[l].getEdgeIterator();
                ++l;
            }
            this.outerEdgeIter = this.model.outer.getEdgeIterator();
            this.sendOuter = sendOuter;
            this.start();
        }

        public void start() {
            this.label = 0;
            int l = 0;
            while (l < this.model.numLabels) {
                this.edgeIter[l].start();
                ++l;
            }
            this.outerEdgeIter.start();
            this.outerEdge = this.outerEdgeIter.next();
            this.outerEdgesSent = this.outerEdge == null || !this.sendOuter;
            this.index2 = 0;
            this.index1 = 0;
        }

        public boolean hasNext() {
            return this.label < this.model.numLabels || !this.outerEdgesSent;
        }

        public Edge nextOuterEdge() {
            this.edge.setStart(this.model.inner[this.outerEdge.getStart()].getEndState(this.index1) + this.model.nodeOffsets[this.outerEdge.getStart()]);
            this.edge.setEnd(this.model.inner[this.outerEdge.getEnd()].getStartState(this.index2) + this.model.nodeOffsets[this.outerEdge.getEnd()]);
            ++this.index2;
            if (this.index2 == this.model.inner[this.outerEdge.getEnd()].getStartStateNum()) {
                this.index2 = 0;
                ++this.index1;
                if (this.index1 == this.model.inner[this.outerEdge.getStart()].getEndStateNum()) {
                    if (this.outerEdgeIter.hasNext()) {
                        this.outerEdge = this.outerEdgeIter.next();
                        this.index2 = 0;
                        this.index1 = 0;
                    } else {
                        this.outerEdgesSent = true;
                    }
                }
            }
            return this.edge;
        }

        public Edge nextInnerEdge() {
            Edge edgeToRet = this.edgeIter[this.label].next();
            this.edge.setStart(edgeToRet.getStart());
            this.edge.setEnd(edgeToRet.getEnd());
            this.edge.setStart(this.edge.getStart() + this.model.nodeOffsets[this.label]);
            this.edge.setEnd(this.edge.getEnd() + this.model.nodeOffsets[this.label]);
            if (!this.edgeIter[this.label].hasNext()) {
                ++this.label;
            }
            return this.edge;
        }

        public Edge next() {
            if (!this.nextIsOuter()) {
                return this.nextInnerEdge();
            }
            return this.nextOuterEdge();
        }

        public boolean nextIsOuter() {
            return this.label >= this.model.numLabels;
        }
    }
}

