/*
 * Decompiled with CFR 0.152.
 */
package dragon.ml.seqmodel.model;

import dragon.ml.seqmodel.model.AbstractModel;
import dragon.ml.seqmodel.model.Edge;
import dragon.ml.seqmodel.model.EdgeIterator;

public class CompleteModel
extends AbstractModel {
    private int markovOrder;
    private int originalLabelNum;

    public CompleteModel(int labelNum) {
        this(labelNum, 1);
    }

    public CompleteModel(int labelNum, int markovOrder) {
        super(labelNum, "Complete");
        this.numLabels = this.computeLabelNum(labelNum, markovOrder);
        this.markovOrder = markovOrder;
        this.originalLabelNum = labelNum;
    }

    public int getOriginalLabelNum() {
        return this.originalLabelNum;
    }

    public int getMarkovOrder() {
        return this.markovOrder;
    }

    public int getLabel(int state) {
        return state;
    }

    public int getEdgeNum() {
        return this.numLabels * this.numLabels;
    }

    public int getStartStateNum() {
        return this.numLabels;
    }

    public int getEndStateNum() {
        return this.numLabels;
    }

    public int getStartState(int i) {
        if (i < this.getStartStateNum()) {
            return i;
        }
        return -1;
    }

    public int getEndState(int i) {
        if (i < this.getEndStateNum()) {
            return i;
        }
        return -1;
    }

    public boolean isEndState(int i) {
        return true;
    }

    public boolean isStartState(int i) {
        return true;
    }

    public EdgeIterator getEdgeIterator() {
        return new SingleEdgeIterator(this.getLabelNum());
    }

    private int computeLabelNum(int originalLabelNum, int markovOrder) {
        int labelNum = originalLabelNum;
        int i = 1;
        while (i < markovOrder) {
            labelNum *= originalLabelNum;
            ++i;
        }
        return labelNum;
    }

    private class SingleEdgeIterator
    implements EdgeIterator {
        private int labelNum;
        private Edge edge;
        private Edge edgeToReturn;

        public SingleEdgeIterator(int labelNum) {
            this.labelNum = labelNum;
            this.edge = new Edge();
            this.edgeToReturn = new Edge();
            this.start();
        }

        public void start() {
            this.edge.setStart(0);
            this.edge.setEnd(0);
        }

        public boolean hasNext() {
            return this.edge.getStart() < this.labelNum;
        }

        public Edge next() {
            this.edgeToReturn.setStart(this.edge.getStart());
            this.edgeToReturn.setEnd(this.edge.getEnd());
            this.edge.setEnd(this.edge.getEnd() + 1);
            if (this.edge.getEnd() == this.labelNum) {
                this.edge.setEnd(0);
                this.edge.setStart(this.edge.getStart() + 1);
            }
            return this.edgeToReturn;
        }

        public boolean nextIsOuter() {
            return true;
        }
    }
}

