/*
 * Decompiled with CFR 0.152.
 */
package dragon.ml.seqmodel.feature;

import dragon.ml.seqmodel.data.DataSequence;
import dragon.ml.seqmodel.feature.AbstractFeatureType;
import dragon.ml.seqmodel.feature.BasicFeature;
import dragon.ml.seqmodel.feature.Feature;
import dragon.ml.seqmodel.feature.FeatureDictionary;
import dragon.ml.seqmodel.feature.FeatureIdentifier;
import dragon.ml.seqmodel.feature.FeatureTypeWord;

public class FeatureTypeWordScore
extends AbstractFeatureType {
    private FeatureDictionary dict;
    private int curState;
    private int tokenId;
    private int stateNum;
    private boolean caseSensitive;

    public FeatureTypeWordScore(FeatureDictionary d) {
        this(d, false);
    }

    public FeatureTypeWordScore(FeatureDictionary d, boolean caseSensitive) {
        super(false);
        this.caseSensitive = caseSensitive;
        this.dict = d;
        this.stateNum = d.getStateNum();
        this.idPrefix = "WS_";
    }

    private void getNextLabel() {
        this.curState = this.dict.getNextStateWithFeature(this.tokenId, this.curState);
    }

    public boolean startScanFeaturesAt(DataSequence data2, int startPos, int endPos) {
        this.curState = -1;
        if (startPos != endPos) {
            System.out.println("The starting position and the ending position should be the same for word score features");
            return false;
        }
        this.tokenId = data2.getToken(endPos).getIndex();
        if (this.tokenId < 0) {
            String token2 = data2.getToken(endPos).getContent();
            if (!this.caseSensitive) {
                token2 = token2.toLowerCase();
            }
            this.tokenId = this.dict.getIndex(token2);
        }
        if (this.tokenId < 0) {
            return false;
        }
        if (this.dict.getCount(this.tokenId) > FeatureTypeWord.RARE_THRESHOLD) {
            this.getNextLabel();
            return true;
        }
        return false;
    }

    public boolean hasNext() {
        return this.curState < this.stateNum && this.curState >= 0;
    }

    public Feature next() {
        FeatureIdentifier id = new FeatureIdentifier(this.idPrefix, this.curState, this.curState);
        double val = Math.log((double)this.dict.getCount(this.tokenId, this.curState) / (double)this.dict.getStateCount(this.curState));
        BasicFeature f2 = new BasicFeature(id, this.curState, val);
        this.getNextLabel();
        return f2;
    }

    public boolean supportSegment() {
        return false;
    }
}

