/*
 * Decompiled with CFR 0.152.
 */
package dragon.ml.seqmodel.feature;

import dragon.ml.seqmodel.data.DataSequence;
import dragon.ml.seqmodel.feature.AbstractFeatureType;
import dragon.ml.seqmodel.feature.BasicFeature;
import dragon.ml.seqmodel.feature.Feature;
import dragon.ml.seqmodel.feature.FeatureIdentifier;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.StringTokenizer;
import java.util.regex.Pattern;

public class FeatureTypeConcatRegex
extends AbstractFeatureType {
    private String[][] patternString = new String[][]{{"isWord", "[a-zA-Z][a-zA-Z]+"}, {"singleCapLetterWithDot", "[A-Z]\\."}, {"singleCapLetter", "[A-Z]"}, {"isDigits", "\\d+"}, {"singleDot", "[.]"}, {"singleComma", "[,]"}, {"isSpecialCharacter", "[#;:\\-/<>'\"()&]"}, {"containsSpecialCharacters", ".*[#;:\\-/<>'\"()&].*"}, {"isInitCapital", "[A-Z][a-z]+"}, {"isAllCapital", "[A-Z]+"}, {"isAllSmallCase", "[a-z]+"}, {"isAlpha", "[a-zA-Z]+"}, {"isAlphaNumeric", "[a-zA-Z0-9]+"}, {"endsWithDot", "\\p{Alnum}+\\."}, {"endsWithComma", "\\w+[,]"}, {"endsWithPunctuation", "\\w+[;:,.?!]"}, {"singlePunctuation", "\\p{Punct}"}, {"singleAmp", "[&]"}, {"containsDigit", ".*\\d+.*"}, {"singleDigit", "\\s*\\d\\s*"}, {"twoDigits", "\\s*\\d{2}\\s*"}, {"threeDigits", "\\s*\\d{3}\\s*"}, {"fourDigits", "\\s*\\(*\\d{4}\\)*\\s*"}, {"isNumberRange", "\\d+\\s*([-]{1,2}\\s*\\d+)?"}, {"isDashSeparatedWords", "(\\w[-])+\\w"}, {"isDashSeparatedSeq", "((\\p{Alpha}+|\\p{Digit}+)[-])+(\\p{Alpha}+|\\p{Digit}+)"}, {"isURL", "\\p{Alpha}+://(\\w+\\.)\\w+(:(\\d{2}|\\d{4}))?(/\\w+)*(/|(/\\w+\\.\\w+))?"}, {"isEmailId", "\\w+@(\\w+\\.)+\\w+"}, {"containsDashes", ".*--.*"}};
    private Pattern[] p;
    protected transient DataSequence data;
    protected int index;
    protected int idbase;
    protected int curId;
    protected int window;
    protected int relSegmentStart;
    protected int relSegmentEnd;
    protected int maxSegmentLength;
    protected int left;
    protected int right;

    public FeatureTypeConcatRegex(int relSegmentStart, int relSegmentEnd, int maxSegmentLength, String patternFile) {
        super(false);
        this.relSegmentStart = relSegmentStart;
        this.relSegmentEnd = relSegmentEnd;
        this.maxSegmentLength = maxSegmentLength;
        this.window = this.getWindowSize(relSegmentStart, relSegmentEnd);
        this.idbase = (int)Math.pow(2.0, this.window);
        this.patternString = this.getPatterns(patternFile);
        this.p = new Pattern[this.patternString.length];
        int i = 0;
        while (i < this.patternString.length) {
            this.p[i] = Pattern.compile(this.patternString[i][1]);
            ++i;
        }
    }

    public FeatureTypeConcatRegex(int relSegmentStart, int relSegmentEnd, int maxSegmentLength, String[][] patternString) {
        super(false);
        this.relSegmentStart = relSegmentStart;
        this.relSegmentEnd = relSegmentEnd;
        this.maxSegmentLength = maxSegmentLength;
        this.window = this.getWindowSize(relSegmentStart, relSegmentEnd);
        this.idbase = (int)Math.pow(2.0, this.window);
        this.patternString = patternString;
        this.p = new Pattern[patternString.length];
        int i = 0;
        while (i < patternString.length) {
            this.p[i] = Pattern.compile(patternString[i][1]);
            ++i;
        }
    }

    public FeatureTypeConcatRegex(int relSegmentStart, int relSegmentEnd, int maxSegmentLength) {
        super(false);
        this.relSegmentStart = relSegmentStart;
        this.relSegmentEnd = relSegmentEnd;
        this.maxSegmentLength = maxSegmentLength;
        this.window = this.getWindowSize(relSegmentStart, relSegmentEnd);
        this.idbase = (int)Math.pow(2.0, this.window);
        this.p = new Pattern[this.patternString.length];
        int i = 0;
        while (i < this.patternString.length) {
            this.p[i] = Pattern.compile(this.patternString[i][1]);
            ++i;
        }
    }

    public FeatureTypeConcatRegex(int relSegmentStart, int relSegmentEnd) {
        this(relSegmentStart, relSegmentEnd, 1);
    }

    public FeatureTypeConcatRegex(int relSegmentStart, int relSegmentEnd, String patternFile) {
        this(relSegmentStart, relSegmentEnd, 1, patternFile);
    }

    private int getWindowSize(int relSegmentStart, int relSegmentEnd) {
        if (this.sign(relSegmentEnd) == this.sign(relSegmentStart) && relSegmentStart != 0) {
            return relSegmentEnd - relSegmentStart + 1;
        }
        return relSegmentEnd - relSegmentStart + this.maxSegmentLength;
    }

    private int sign(int boundary) {
        if (boundary == 0) {
            return 0;
        }
        if (boundary < 0) {
            return -1;
        }
        return 1;
    }

    public boolean startScanFeaturesAt(DataSequence data2, int startPos, int endPos) {
        this.data = data2;
        this.index = 0;
        this.left = this.relSegmentStart <= 0 ? startPos + this.relSegmentStart : endPos + this.relSegmentStart;
        this.right = this.relSegmentEnd < 0 ? startPos + this.relSegmentEnd : endPos + this.relSegmentEnd;
        if (this.left < 0 || this.left >= data2.length() || this.right < 0 || this.right >= data2.length()) {
            this.index = this.patternString.length;
        }
        this.advance();
        return true;
    }

    public boolean hasNext() {
        return this.index < this.patternString.length;
    }

    public Feature next() {
        int curState = -1;
        String name = this.patternString[this.index][0] + "_" + this.window + "_" + Integer.toBinaryString(this.curId);
        FeatureIdentifier id = new FeatureIdentifier(name, this.curId + this.idbase * this.index++, curState);
        BasicFeature f2 = new BasicFeature(id, curState, 1.0);
        this.advance();
        return f2;
    }

    private void advance() {
        this.curId = 0;
        while (this.curId <= 0 && this.index < this.patternString.length) {
            int base = 1;
            int k = this.left;
            while (k <= this.right) {
                boolean match = this.p[this.index].matcher(this.data.getToken(k).getContent()).matches();
                this.curId += base * (match ? 1 : 0);
                base *= 2;
                ++k;
            }
            if (this.curId > 0) break;
            ++this.index;
        }
    }

    private String[][] getPatterns(String patternFile) {
        try {
            BufferedReader in = new BufferedReader(new FileReader(patternFile));
            int len = Integer.parseInt(in.readLine());
            String[][] patterns = new String[len][2];
            int k = 0;
            while (k < len) {
                StringTokenizer strTokenizer = new StringTokenizer(in.readLine());
                patterns[k][0] = strTokenizer.nextToken();
                patterns[k][1] = strTokenizer.nextToken();
                ++k;
            }
            return patterns;
        }
        catch (IOException ioe) {
            System.err.println("Could not read pattern file : " + patternFile);
            ioe.printStackTrace();
            return null;
        }
    }
}

