/*
 * Decompiled with CFR 0.152.
 */
package dragon.ml.seqmodel.feature;

import dragon.ml.seqmodel.data.DataSequence;
import dragon.ml.seqmodel.data.Dataset;
import dragon.ml.seqmodel.feature.Feature;
import dragon.ml.seqmodel.feature.FeatureGenerator;
import dragon.ml.seqmodel.feature.FeatureMap;
import dragon.ml.seqmodel.feature.FeatureType;
import dragon.ml.seqmodel.model.ModelGraph;
import java.io.BufferedReader;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.Vector;

public class BasicFeatureGenerator
implements FeatureGenerator {
    protected ModelGraph model;
    protected Vector featureVector;
    protected Iterator featureIter;
    protected FeatureType currentFeatureType;
    protected FeatureMap featureMap;
    protected Feature featureToReturn;
    protected DataSequence curSeq;
    protected int curStartPos;
    protected int curEndPos;
    protected int totalFeatures;
    protected boolean featureCollectingMode;
    protected boolean supportSegment;

    public BasicFeatureGenerator(ModelGraph model) {
        this(model, false);
    }

    public BasicFeatureGenerator(ModelGraph model, boolean supportSegment) {
        this.model = model;
        this.totalFeatures = 0;
        this.supportSegment = supportSegment;
        this.featureVector = new Vector();
        this.featureToReturn = null;
        this.featureMap = new FeatureMap();
        this.featureCollectingMode = false;
    }

    public boolean supportSegment() {
        return this.supportSegment;
    }

    public boolean addFeatureType(FeatureType fType) {
        if (this.featureMap.isFrozen()) {
            return false;
        }
        if (this.supportSegment() && !fType.supportSegment()) {
            return false;
        }
        fType.setTypeID(this.featureVector.size());
        this.featureVector.add(fType);
        return true;
    }

    public int getFeatureTypeNum() {
        return this.featureVector.size();
    }

    public FeatureType getFeatureTYpe(int index) {
        return (FeatureType)this.featureVector.get(index);
    }

    protected FeatureType getFeatureType(int i) {
        return (FeatureType)this.featureVector.elementAt(i);
    }

    public boolean train(Dataset trainData) {
        int i = 0;
        while (i < this.featureVector.size()) {
            FeatureType cur = this.getFeatureType(i);
            if (cur.needTraining()) {
                if (!cur.train(trainData)) {
                    return false;
                }
                cur.saveTrainingResult();
            }
            ++i;
        }
        this.collectFeatureIdentifiers(trainData);
        this.totalFeatures = this.featureMap.getFeatureNum();
        return true;
    }

    public boolean loadFeatureData() {
        int i = 0;
        while (i < this.featureVector.size()) {
            FeatureType cur = this.getFeatureType(i);
            if (cur.needTraining()) {
                cur.readTrainingResult();
            }
            ++i;
        }
        return true;
    }

    protected void collectFeatureIdentifiers(Dataset trainData) {
        this.featureCollectingMode = true;
        trainData.startScan();
        while (trainData.hasNext()) {
            DataSequence seq2 = trainData.next();
            int segStart = 0;
            while (segStart < seq2.length()) {
                int segEnd = this.supportSegment ? seq2.getSegmentEnd(segStart) : segStart;
                this.startScanFeaturesAt(seq2, segStart, segEnd);
                while (this.hasNext()) {
                    this.next();
                }
                segStart = segEnd + 1;
            }
        }
        this.featureCollectingMode = false;
        this.featureMap.freezeFeatures();
    }

    /*
     * Unable to fully structure code
     */
    protected void advance() {
        while (true) {
            if ((this.currentFeatureType == null || !this.currentFeatureType.hasNext()) && this.featureIter.hasNext()) {
                this.currentFeatureType = (FeatureType)this.featureIter.next();
                continue;
            }
            if (this.currentFeatureType.hasNext()) ** GOTO lbl21
            break;
lbl-1000:
            // 1 sources

            {
                this.featureToReturn = this.currentFeatureType.next();
                id = this.featureToReturn.getID();
                id.setId(id.getId() * this.getFeatureTypeNum() + this.currentFeatureType.getTypeID());
                featureIndex = this.featureMap.getId(id);
                if (featureIndex < 0 && this.featureCollectingMode && this.retainFeature(this.curSeq, this.featureToReturn)) {
                    featureIndex = this.featureMap.add(id);
                }
                if (featureIndex < 0) {
                    this.featureToReturn = null;
                    continue;
                }
                this.featureToReturn.setIndex(featureIndex);
                if (!this.isValidFeature(this.curSeq, this.curStartPos, this.curEndPos, this.featureToReturn)) {
                    this.featureToReturn = null;
                    continue;
                }
                return;
lbl21:
                // 3 sources

                ** while (this.currentFeatureType.hasNext())
            }
lbl22:
            // 1 sources

        }
        this.featureToReturn = null;
    }

    protected boolean isValidFeature(DataSequence data2, int curStartPos, int curEndPos, Feature featureToReturn) {
        if (curStartPos > 0 && curEndPos < data2.length() - 1) {
            return true;
        }
        if (curStartPos == 0 && this.model.isStartState(featureToReturn.getLabel()) && (data2.length() > 1 || this.model.isEndState(featureToReturn.getLabel()))) {
            return true;
        }
        return curEndPos == data2.length() - 1 && this.model.isEndState(featureToReturn.getLabel());
    }

    protected boolean retainFeature(DataSequence seq2, Feature f2) {
        return seq2.getLabel(this.curEndPos) == f2.getLabel() && (this.curStartPos == 0 || f2.getPrevLabel() < 0 || seq2.getLabel(this.curStartPos - 1) == f2.getPrevLabel());
    }

    protected void initScanFeaturesAt(DataSequence d) {
        this.curSeq = d;
        this.currentFeatureType = null;
        this.featureIter = this.featureVector.iterator();
        this.advance();
    }

    public void startScanFeaturesAt(DataSequence d, int startPos, int endPos) {
        this.curStartPos = startPos;
        this.curEndPos = endPos;
        int i = 0;
        while (i < this.featureVector.size()) {
            this.getFeatureType(i).startScanFeaturesAt(d, startPos, endPos);
            ++i;
        }
        this.initScanFeaturesAt(d);
    }

    public boolean hasNext() {
        return this.featureToReturn != null;
    }

    public Feature next() {
        Feature cur = this.featureToReturn.copy();
        this.advance();
        return cur;
    }

    public int getFeatureNum() {
        return this.totalFeatures;
    }

    public String getFeatureName(int featureIndex) {
        return this.featureMap.getName(featureIndex);
    }

    public boolean readFeatures(String fileName) {
        try {
            BufferedReader in = new BufferedReader(new FileReader(fileName));
            this.totalFeatures = this.featureMap.read(in);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean saveFeatures(String fileName) {
        try {
            PrintWriter out = new PrintWriter(new FileOutputStream(fileName));
            this.featureMap.write(out);
            out.close();
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }
}

