/*
 * Decompiled with CFR 0.152.
 */
package dragon.ml.seqmodel.crf;

import dragon.matrix.DoubleFlatDenseMatrix;
import dragon.ml.seqmodel.crf.AbstractCRF;
import dragon.ml.seqmodel.crf.Labeler;
import dragon.ml.seqmodel.data.DataSequence;
import dragon.ml.seqmodel.feature.FeatureGenerator;
import dragon.ml.seqmodel.model.ModelGraph;
import dragon.util.MathUtil;

public class ViterbiSegmentLabeler
extends AbstractCRF
implements Labeler {
    private int maxLen;
    private int[][] winningLabel;
    private int[][] winningPos;
    private double[] score;
    private int[] solutionOrder;

    public ViterbiSegmentLabeler(ModelGraph model, FeatureGenerator featureGenerator, int maxSegmentLength) {
        super(model, featureGenerator);
        this.maxLen = maxSegmentLength;
        this.score = new double[model.getStateNum()];
    }

    public boolean label(DataSequence dataSeq) {
        return this.label(dataSeq, this.lambda);
    }

    public boolean label(DataSequence dataSeq, double[] lambda) {
        int stateNum = this.model.getStateNum();
        DoubleFlatDenseMatrix transMatrix = new DoubleFlatDenseMatrix(stateNum, stateNum);
        DoubleFlatDenseMatrix[] scoreMatrix = new DoubleFlatDenseMatrix[this.maxLen];
        int i = 0;
        while (i < this.maxLen) {
            scoreMatrix[i] = new DoubleFlatDenseMatrix(stateNum, stateNum);
            ++i;
        }
        double[][] partialScore = new double[dataSeq.length()][stateNum];
        this.winningLabel = new int[dataSeq.length()][stateNum];
        this.winningPos = new int[dataSeq.length()][stateNum];
        i = 0;
        while (i < dataSeq.length()) {
            int yp;
            int yi;
            int ell;
            if (i > 0) {
                ell = 0;
                while (ell < this.maxLen && i - ell > 0) {
                    this.computeTransMatrix(lambda, dataSeq, i - ell, i, transMatrix, false);
                    scoreMatrix[ell].assign(0.0);
                    yi = 0;
                    while (yi < stateNum) {
                        yp = 0;
                        while (yp < stateNum) {
                            scoreMatrix[ell].setDouble(yp, yi, partialScore[i - ell - 1][yp] + transMatrix.getDouble(yp, yi));
                            ++yp;
                        }
                        ++yi;
                    }
                    ++ell;
                }
            } else {
                yi = 0;
                while (yi < stateNum) {
                    partialScore[i][yi] = transMatrix.getDouble(0, yi);
                    this.winningPos[i][yi] = 0;
                    ++yi;
                }
            }
            if (i > 0) {
                yi = 0;
                while (yi < stateNum) {
                    int prevLabel = -1;
                    int startPos = -1;
                    double maxScore = -1.0;
                    ell = 0;
                    while (ell < this.maxLen && i - ell >= 0) {
                        yp = 0;
                        while (yp < stateNum) {
                            if (scoreMatrix[ell].getDouble(yp, yi) > maxScore) {
                                maxScore = scoreMatrix[ell].getDouble(yp, yi);
                                prevLabel = yp;
                                startPos = i - ell;
                            }
                            ++yp;
                        }
                        ++ell;
                    }
                    partialScore[i][yi] = maxScore;
                    this.winningLabel[i][yi] = prevLabel;
                    this.winningPos[i][yi] = startPos;
                    ++yi;
                }
            }
            ++i;
        }
        MathUtil.copyArray(partialScore[dataSeq.length() - 1], this.score);
        this.solutionOrder = MathUtil.rankElementInArray(this.score, true);
        this.getBestSolution(dataSeq, 0);
        return true;
    }

    public double getBestSolution(DataSequence dataSeq, int order) {
        int endPos = dataSeq.length() - 1;
        int prevLabel = this.solutionOrder[order];
        int startPos = this.winningPos[endPos][prevLabel];
        while (startPos >= 0) {
            dataSeq.setSegment(startPos, endPos, prevLabel);
            prevLabel = this.winningLabel[endPos][prevLabel];
            endPos = startPos - 1;
            if (endPos < 0) break;
            startPos = this.winningPos[endPos][prevLabel];
        }
        this.model.mapStateToLabel(dataSeq);
        return this.score[this.solutionOrder[order]];
    }
}

