/*
 * Decompiled with CFR 0.152.
 */
package dragon.ml.seqmodel.crf;

import dragon.matrix.DoubleDenseMatrix;
import dragon.ml.seqmodel.crf.EdgeGenerator;
import dragon.ml.seqmodel.data.DataSequence;
import dragon.ml.seqmodel.feature.Feature;
import dragon.ml.seqmodel.feature.FeatureGenerator;
import dragon.ml.seqmodel.model.ModelGraph;
import java.io.BufferedReader;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.PrintWriter;

public abstract class AbstractCRF {
    protected EdgeGenerator edgeGen;
    protected FeatureGenerator featureGenerator;
    protected ModelGraph model;
    protected double[] lambda;

    public AbstractCRF(ModelGraph model, FeatureGenerator featureGen) {
        this.model = model;
        this.edgeGen = new EdgeGenerator(model.getMarkovOrder(), model.getOriginalLabelNum());
        this.featureGenerator = featureGen;
    }

    public FeatureGenerator getFeatureGenerator() {
        return this.featureGenerator;
    }

    public ModelGraph getModelGraph() {
        return this.model;
    }

    public double[] getModelParameter() {
        return this.lambda;
    }

    public boolean saveModelParameter(String filename) {
        try {
            PrintWriter out = new PrintWriter(new FileOutputStream(filename));
            out.println(this.lambda.length);
            int i = 0;
            while (i < this.lambda.length) {
                out.println(this.lambda[i]);
                ++i;
            }
            out.close();
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    /*
     * WARNING - void declaration
     */
    public boolean readModelParameter(String filename) {
        try {
            String line;
            BufferedReader in = new BufferedReader(new FileReader(filename));
            int featureNum = Integer.parseInt(in.readLine());
            this.lambda = new double[featureNum];
            int pos = 0;
            while ((line = in.readLine()) != null) {
                void var3_5;
                this.lambda[pos++] = Double.parseDouble((String)var3_5);
            }
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    protected void computeTransMatrix(double[] lambda, DataSequence data2, int startPos, int endPos, DoubleDenseMatrix transMatrix, boolean takeExp) {
        this.featureGenerator.startScanFeaturesAt(data2, startPos, endPos);
        this.computeTransMatrix(lambda, transMatrix, takeExp);
    }

    protected void computeTransMatrix(double[] lambda, DoubleDenseMatrix transMatrix, boolean takeExp) {
        int j;
        int stateNum = transMatrix.rows();
        double[] stateFeatureCost = new double[stateNum];
        transMatrix.assign(0.0);
        while (this.featureGenerator.hasNext()) {
            Feature feature = this.featureGenerator.next();
            int label = feature.getLabel();
            int index = feature.getIndex();
            if (feature.getPrevLabel() < 0) {
                int n = label;
                stateFeatureCost[n] = stateFeatureCost[n] + lambda[index] * feature.getValue();
                continue;
            }
            transMatrix.add(feature.getPrevLabel(), label, lambda[index] * feature.getValue());
        }
        int i = 0;
        while (i < stateNum) {
            j = 0;
            while (j < stateNum) {
                transMatrix.setDouble(j, i, transMatrix.getDouble(j, i) + stateFeatureCost[i]);
                ++j;
            }
            ++i;
        }
        if (takeExp) {
            i = 0;
            while (i < stateNum) {
                j = 0;
                while (j < stateNum) {
                    transMatrix.setDouble(i, j, Math.exp(transMatrix.getDouble(i, j)));
                    ++j;
                }
                ++i;
            }
        }
    }
}

