/*
 * Decompiled with CFR 0.152.
 */
package dragon.matrix.vector;

import dragon.util.MathUtil;
import java.io.Serializable;

public class IntVector
implements Serializable {
    private static final long serialVersionUID = 1L;
    private int[] vector;

    public IntVector(int size2) {
        this.vector = new int[size2];
    }

    public IntVector(int[] vector) {
        this.vector = vector;
    }

    public IntVector copy() {
        int[] newVector = new int[this.vector.length];
        System.arraycopy(this.vector, 0, newVector, 0, this.vector.length);
        return new IntVector(newVector);
    }

    public void assign(int initValue) {
        int i = 0;
        while (i < this.vector.length) {
            this.vector[i] = initValue;
            ++i;
        }
    }

    public void assign(IntVector newVector) {
        int i = 0;
        while (i < this.vector.length) {
            this.vector[i] = newVector.get(i);
            ++i;
        }
    }

    public void multiply(int rate) {
        int i = 0;
        while (i < this.vector.length) {
            int n = i++;
            this.vector[n] = this.vector[n] * rate;
        }
    }

    public void add(IntVector newVector) {
        if (this.vector.length != newVector.size()) {
            return;
        }
        int i = 0;
        while (i < this.vector.length) {
            int n = i;
            this.vector[n] = this.vector[n] + newVector.get(i);
            ++i;
        }
    }

    public void add(int index, int inc) {
        int n = index;
        this.vector[n] = this.vector[n] + inc;
    }

    public int get(int index) {
        return this.vector[index];
    }

    public void set(int index, int value2) {
        this.vector[index] = value2;
    }

    public int size() {
        return this.vector.length;
    }

    public double distance() {
        int sum2 = 0;
        int i = 0;
        while (i < this.vector.length) {
            sum2 += this.vector[i] * this.vector[i];
            ++i;
        }
        return Math.sqrt(sum2);
    }

    public double distance(IntVector origin) {
        if (this.vector.length != origin.size()) {
            return -1.0;
        }
        int sum2 = 0;
        int i = 0;
        while (i < this.vector.length) {
            int a = this.vector[i] - origin.get(i);
            sum2 += a * a;
            ++i;
        }
        return Math.sqrt(sum2);
    }

    public int[] rank(boolean desc) {
        return MathUtil.rankElementInArray(this.vector, desc);
    }

    public int getDimWithMaxValue() {
        return MathUtil.maxElementInArray(this.vector);
    }

    public int getMaxValue() {
        return MathUtil.max(this.vector);
    }

    public int getMinValue() {
        return MathUtil.min(this.vector);
    }

    public double getAvgValue() {
        return MathUtil.average(this.vector);
    }

    public int getSummation() {
        return MathUtil.sumArray(this.vector);
    }

    public int dotProduct(IntVector newVector) {
        int product2 = 0;
        int i = 0;
        while (i < this.vector.length) {
            product2 += this.vector[i] * newVector.get(i);
            ++i;
        }
        return product2;
    }
}

