/*
 * Decompiled with CFR 0.152.
 */
package dragon.matrix.factorize;

import dragon.matrix.DoubleDenseMatrix;
import dragon.matrix.DoubleFlatDenseMatrix;
import dragon.matrix.SparseMatrix;
import dragon.matrix.factorize.AbstractFactorization;

public class NMF
extends AbstractFactorization {
    private SparseMatrix xt;
    private DoubleDenseMatrix u;
    private DoubleDenseMatrix m;
    private DoubleDenseMatrix v;
    private int iterations;

    public NMF(int iterations) {
        this.iterations = iterations;
    }

    public void factorize(SparseMatrix x2, int dimension) {
        DoubleFlatDenseMatrix vtv;
        this.xt = (SparseMatrix)x2.transpose();
        this.u = this.genPositiveMatrix(x2.rows(), dimension);
        this.v = this.genPositiveMatrix(x2.columns(), dimension);
        DoubleFlatDenseMatrix xv = new DoubleFlatDenseMatrix(x2.rows(), dimension);
        DoubleFlatDenseMatrix vt = new DoubleFlatDenseMatrix(dimension, x2.columns());
        DoubleFlatDenseMatrix utu = vtv = new DoubleFlatDenseMatrix(dimension, dimension);
        DoubleFlatDenseMatrix uvtv = new DoubleFlatDenseMatrix(x2.rows(), dimension);
        DoubleFlatDenseMatrix xtu = new DoubleFlatDenseMatrix(x2.columns(), dimension);
        DoubleFlatDenseMatrix ut = new DoubleFlatDenseMatrix(dimension, x2.rows());
        DoubleFlatDenseMatrix vutu = new DoubleFlatDenseMatrix(x2.columns(), dimension);
        int k = 0;
        while (k < this.iterations) {
            double score;
            int j;
            this.product(x2, this.v, (DoubleDenseMatrix)xv);
            this.transpose(this.v, vt);
            this.product(vt, this.v, (DoubleDenseMatrix)vtv);
            this.product(this.u, (DoubleDenseMatrix)vtv, (DoubleDenseMatrix)uvtv);
            this.product(this.xt, this.u, (DoubleDenseMatrix)xtu);
            this.transpose(this.u, ut);
            this.product(ut, this.u, (DoubleDenseMatrix)utu);
            this.product(this.v, (DoubleDenseMatrix)utu, (DoubleDenseMatrix)vutu);
            int i = 0;
            while (i < this.v.rows()) {
                j = 0;
                while (j < this.v.columns()) {
                    score = vutu.getDouble(i, j) + 1.0E-9;
                    score = this.v.getDouble(i, j) * xtu.getDouble(i, j) / score;
                    this.v.setDouble(i, j, score);
                    ++j;
                }
                ++i;
            }
            i = 0;
            while (i < this.u.rows()) {
                j = 0;
                while (j < this.u.columns()) {
                    score = uvtv.getDouble(i, j) + 1.0E-9;
                    score = this.u.getDouble(i, j) * xv.getDouble(i, j) / score;
                    this.u.setDouble(i, j, score);
                    ++j;
                }
                ++i;
            }
            this.normalizeColumn(this.u);
            ++k;
        }
    }

    public DoubleDenseMatrix getLeftMatrix() {
        return this.u;
    }

    public DoubleDenseMatrix getRightMatrix() {
        return this.v;
    }

    public DoubleDenseMatrix getMiddleMatrix() {
        return this.m;
    }
}

