/*
 * Decompiled with CFR 0.152.
 */
package dragon.matrix.factorize;

import dragon.matrix.DoubleDenseMatrix;
import dragon.matrix.DoubleFlatDenseMatrix;
import dragon.matrix.SparseMatrix;
import dragon.matrix.factorize.Factorization;
import java.util.Random;

public abstract class AbstractFactorization
implements Factorization {
    public static final double SMALL_QUANTITY = 1.0E-9;

    protected DoubleDenseMatrix genPositiveMatrix(int x2, int y) {
        Random rand = new Random(1L);
        DoubleFlatDenseMatrix matrix = new DoubleFlatDenseMatrix(x2, y);
        int i = 0;
        while (i < x2) {
            int j = 0;
            while (j < y) {
                matrix.setDouble(i, j, rand.nextDouble() + 1.0E-9);
                ++j;
            }
            ++i;
        }
        return matrix;
    }

    protected void product(DoubleDenseMatrix a, DoubleDenseMatrix b, DoubleDenseMatrix c) {
        int row = 0;
        while (row < a.rows()) {
            int col = 0;
            while (col < b.columns()) {
                double score = 0.0;
                int i = 0;
                while (i < a.columns()) {
                    score += a.getDouble(row, i) * b.getDouble(i, col);
                    ++i;
                }
                c.setDouble(row, col, score);
                ++col;
            }
            ++row;
        }
    }

    protected void product(SparseMatrix a, DoubleDenseMatrix b, DoubleDenseMatrix c) {
        int row = 0;
        while (row < a.rows()) {
            int[] arrColumn = a.getNonZeroColumnsInRow(row);
            double[] arrScore = a.getNonZeroDoubleScoresInRow(row);
            int col = 0;
            while (col < b.columns()) {
                double score = 0.0;
                int i = 0;
                while (i < arrColumn.length) {
                    score += arrScore[i] * b.getDouble(arrColumn[i], col);
                    ++i;
                }
                c.setDouble(row, col, score);
                ++col;
            }
            ++row;
        }
    }

    protected void transpose(DoubleDenseMatrix a, DoubleDenseMatrix at) {
        int row = 0;
        while (row < a.rows()) {
            int col = 0;
            while (col < a.columns()) {
                at.setDouble(col, row, a.getDouble(row, col));
                ++col;
            }
            ++row;
        }
    }

    protected void normalizeColumn(DoubleDenseMatrix a) {
        int col = 0;
        while (col < a.columns()) {
            double score;
            double norm = 0.0;
            int row = 0;
            while (row < a.rows()) {
                score = a.getDouble(row, col);
                norm += score * score;
                ++row;
            }
            norm = Math.sqrt(norm);
            row = 0;
            while (row < a.rows()) {
                score = a.getDouble(row, col);
                a.setDouble(row, col, score / norm);
                ++row;
            }
            ++col;
        }
    }
}

